package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Security Events Provider with issuer and JWKS settings for signal ingestion
 */
@ApiModel(description = "Security Events Provider with issuer and JWKS settings for signal ingestion")
@JsonPropertyOrder({ SecurityEventsProviderSettingsNonSSFCompliant.JSON_PROPERTY_ISSUER,
        SecurityEventsProviderSettingsNonSSFCompliant.JSON_PROPERTY_JWKS_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SecurityEventsProviderSettingsNonSSFCompliant implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;

    public static final String JSON_PROPERTY_JWKS_URL = "jwks_url";
    private String jwksUrl;

    public SecurityEventsProviderSettingsNonSSFCompliant() {
    }

    public SecurityEventsProviderSettingsNonSSFCompliant issuer(String issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * Issuer URL
     *
     * @return issuer
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "example.okta.com", required = true, value = "Issuer URL")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SecurityEventsProviderSettingsNonSSFCompliant jwksUrl(String jwksUrl) {

        this.jwksUrl = jwksUrl;
        return this;
    }

    /**
     * The public URL where the JWKS public key is uploaded
     *
     * @return jwksUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://example.okta.com/oauth2/v1/keys", required = true, value = "The public URL where the JWKS public key is uploaded")
    @JsonProperty(JSON_PROPERTY_JWKS_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getJwksUrl() {
        return jwksUrl;
    }

    @JsonProperty(JSON_PROPERTY_JWKS_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderSettingsNonSSFCompliant securityEventsProviderSettingsNonSSFCompliant = (SecurityEventsProviderSettingsNonSSFCompliant) o;
        return Objects.equals(this.issuer, securityEventsProviderSettingsNonSSFCompliant.issuer)
                && Objects.equals(this.jwksUrl, securityEventsProviderSettingsNonSSFCompliant.jwksUrl);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(issuer, jwksUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderSettingsNonSSFCompliant {\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    jwksUrl: ").append(toIndentedString(jwksUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
