package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PolicyContext;
import com.okta.sdk.resource.model.PolicyTypeSimulation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The request body required for a simulate policy operation
 */
@ApiModel(description = "The request body required for a simulate policy operation")
@JsonPropertyOrder({ SimulatePolicyBody.JSON_PROPERTY_APP_INSTANCE, SimulatePolicyBody.JSON_PROPERTY_POLICY_CONTEXT,
        SimulatePolicyBody.JSON_PROPERTY_POLICY_TYPES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SimulatePolicyBody implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APP_INSTANCE = "appInstance";
    private String appInstance;

    public static final String JSON_PROPERTY_POLICY_CONTEXT = "policyContext";
    private PolicyContext policyContext;

    public static final String JSON_PROPERTY_POLICY_TYPES = "policyTypes";
    private List<PolicyTypeSimulation> policyTypes = null;

    public SimulatePolicyBody() {
    }

    public SimulatePolicyBody appInstance(String appInstance) {

        this.appInstance = appInstance;
        return this;
    }

    /**
     * The application instance ID for a simulate operation
     *
     * @return appInstance
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The application instance ID for a simulate operation")
    @JsonProperty(JSON_PROPERTY_APP_INSTANCE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAppInstance() {
        return appInstance;
    }

    @JsonProperty(JSON_PROPERTY_APP_INSTANCE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAppInstance(String appInstance) {
        this.appInstance = appInstance;
    }

    public SimulatePolicyBody policyContext(PolicyContext policyContext) {

        this.policyContext = policyContext;
        return this;
    }

    /**
     * Get policyContext
     *
     * @return policyContext
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_POLICY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyContext getPolicyContext() {
        return policyContext;
    }

    @JsonProperty(JSON_PROPERTY_POLICY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPolicyContext(PolicyContext policyContext) {
        this.policyContext = policyContext;
    }

    public SimulatePolicyBody policyTypes(List<PolicyTypeSimulation> policyTypes) {

        this.policyTypes = policyTypes;
        return this;
    }

    public SimulatePolicyBody addpolicyTypesItem(PolicyTypeSimulation policyTypesItem) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<>();
        }
        this.policyTypes.add(policyTypesItem);
        return this;
    }

    /**
     * Supported policy types for a simulate operation. The default value, &#x60;null&#x60;, returns all types.
     *
     * @return policyTypes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Supported policy types for a simulate operation. The default value, `null`, returns all types.")
    @JsonProperty(JSON_PROPERTY_POLICY_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<PolicyTypeSimulation> getPolicyTypes() {
        return policyTypes;
    }

    @JsonProperty(JSON_PROPERTY_POLICY_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPolicyTypes(List<PolicyTypeSimulation> policyTypes) {
        this.policyTypes = policyTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SimulatePolicyBody simulatePolicyBody = (SimulatePolicyBody) o;
        return Objects.equals(this.appInstance, simulatePolicyBody.appInstance)
                && Objects.equals(this.policyContext, simulatePolicyBody.policyContext)
                && Objects.equals(this.policyTypes, simulatePolicyBody.policyTypes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(appInstance, policyContext, policyTypes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimulatePolicyBody {\n");
        sb.append("    appInstance: ").append(toIndentedString(appInstance)).append("\n");
        sb.append("    policyContext: ").append(toIndentedString(policyContext)).append("\n");
        sb.append("    policyTypes: ").append(toIndentedString(policyTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
