package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Determines if the app supports Single Logout (SLO)
 */
@ApiModel(description = "Determines if the app supports Single Logout (SLO)")
@JsonPropertyOrder({ SingleLogout.JSON_PROPERTY_ENABLED, SingleLogout.JSON_PROPERTY_ISSUER,
        SingleLogout.JSON_PROPERTY_LOGOUT_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SingleLogout implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;

    public static final String JSON_PROPERTY_LOGOUT_URL = "logoutUrl";
    private String logoutUrl;

    public SingleLogout() {
    }

    public SingleLogout enabled(Boolean enabled) {

        this.enabled = enabled;
        return this;
    }

    /**
     * Whether the application supports SLO
     *
     * @return enabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Whether the application supports SLO")
    @JsonProperty(JSON_PROPERTY_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getEnabled() {
        return enabled;
    }

    @JsonProperty(JSON_PROPERTY_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SingleLogout issuer(String issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * The issuer of the Service Provider that generates the SLO request
     *
     * @return issuer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The issuer of the Service Provider that generates the SLO request")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SingleLogout logoutUrl(String logoutUrl) {

        this.logoutUrl = logoutUrl;
        return this;
    }

    /**
     * The location where the logout response is sent
     *
     * @return logoutUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The location where the logout response is sent")
    @JsonProperty(JSON_PROPERTY_LOGOUT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogoutUrl() {
        return logoutUrl;
    }

    @JsonProperty(JSON_PROPERTY_LOGOUT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SingleLogout singleLogout = (SingleLogout) o;
        return Objects.equals(this.enabled, singleLogout.enabled) && Objects.equals(this.issuer, singleLogout.issuer)
                && Objects.equals(this.logoutUrl, singleLogout.logoutUrl);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enabled, issuer, logoutUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SingleLogout {\n");
        sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    logoutUrl: ").append(toIndentedString(logoutUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
