package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * StandardRoleAssignmentSchema
 */
@JsonPropertyOrder({ StandardRoleAssignmentSchema.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class StandardRoleAssignmentSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public StandardRoleAssignmentSchema() {
    }

    public StandardRoleAssignmentSchema type(String type) {

        this.type = type;
        return this;
    }

    /**
     * Specify the standard or IAM-based role type. See [standard
     * roles](/openapi/okta-management/guides/roles/#standard-roles).
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specify the standard or IAM-based role type. See [standard roles](/openapi/okta-management/guides/roles/#standard-roles).")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StandardRoleAssignmentSchema standardRoleAssignmentSchema = (StandardRoleAssignmentSchema) o;
        return Objects.equals(this.type, standardRoleAssignmentSchema.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandardRoleAssignmentSchema {\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
