package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TestInfoOidcTestConfiguration;
import com.okta.sdk.resource.model.TestInfoSamlTestConfiguration;
import com.okta.sdk.resource.model.TestInfoTestAccount;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Integration Testing Information
 */
@ApiModel(description = "Integration Testing Information")
@JsonPropertyOrder({ TestInfo.JSON_PROPERTY_ESCALATION_SUPPORT_CONTACT, TestInfo.JSON_PROPERTY_OIDC_TEST_CONFIGURATION,
        TestInfo.JSON_PROPERTY_SAML_TEST_CONFIGURATION, TestInfo.JSON_PROPERTY_TEST_ACCOUNT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class TestInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ESCALATION_SUPPORT_CONTACT = "escalationSupportContact";
    private String escalationSupportContact;

    public static final String JSON_PROPERTY_OIDC_TEST_CONFIGURATION = "oidcTestConfiguration";
    private TestInfoOidcTestConfiguration oidcTestConfiguration;

    public static final String JSON_PROPERTY_SAML_TEST_CONFIGURATION = "samlTestConfiguration";
    private TestInfoSamlTestConfiguration samlTestConfiguration;

    public static final String JSON_PROPERTY_TEST_ACCOUNT = "testAccount";
    private TestInfoTestAccount testAccount;

    public TestInfo() {
    }

    public TestInfo escalationSupportContact(String escalationSupportContact) {

        this.escalationSupportContact = escalationSupportContact;
        return this;
    }

    /**
     * An email for Okta to contact your company about your integration. This email isn&#39;t shared with customers.
     *
     * @return escalationSupportContact
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "strawberry.support@example.com", required = true, value = "An email for Okta to contact your company about your integration. This email isn't shared with customers.")
    @JsonProperty(JSON_PROPERTY_ESCALATION_SUPPORT_CONTACT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getEscalationSupportContact() {
        return escalationSupportContact;
    }

    @JsonProperty(JSON_PROPERTY_ESCALATION_SUPPORT_CONTACT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEscalationSupportContact(String escalationSupportContact) {
        this.escalationSupportContact = escalationSupportContact;
    }

    public TestInfo oidcTestConfiguration(TestInfoOidcTestConfiguration oidcTestConfiguration) {

        this.oidcTestConfiguration = oidcTestConfiguration;
        return this;
    }

    /**
     * Get oidcTestConfiguration
     *
     * @return oidcTestConfiguration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OIDC_TEST_CONFIGURATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TestInfoOidcTestConfiguration getOidcTestConfiguration() {
        return oidcTestConfiguration;
    }

    @JsonProperty(JSON_PROPERTY_OIDC_TEST_CONFIGURATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOidcTestConfiguration(TestInfoOidcTestConfiguration oidcTestConfiguration) {
        this.oidcTestConfiguration = oidcTestConfiguration;
    }

    public TestInfo samlTestConfiguration(TestInfoSamlTestConfiguration samlTestConfiguration) {

        this.samlTestConfiguration = samlTestConfiguration;
        return this;
    }

    /**
     * Get samlTestConfiguration
     *
     * @return samlTestConfiguration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SAML_TEST_CONFIGURATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TestInfoSamlTestConfiguration getSamlTestConfiguration() {
        return samlTestConfiguration;
    }

    @JsonProperty(JSON_PROPERTY_SAML_TEST_CONFIGURATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSamlTestConfiguration(TestInfoSamlTestConfiguration samlTestConfiguration) {
        this.samlTestConfiguration = samlTestConfiguration;
    }

    public TestInfo testAccount(TestInfoTestAccount testAccount) {

        this.testAccount = testAccount;
        return this;
    }

    /**
     * Get testAccount
     *
     * @return testAccount
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TEST_ACCOUNT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TestInfoTestAccount getTestAccount() {
        return testAccount;
    }

    @JsonProperty(JSON_PROPERTY_TEST_ACCOUNT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTestAccount(TestInfoTestAccount testAccount) {
        this.testAccount = testAccount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TestInfo testInfo = (TestInfo) o;
        return Objects.equals(this.escalationSupportContact, testInfo.escalationSupportContact)
                && Objects.equals(this.oidcTestConfiguration, testInfo.oidcTestConfiguration)
                && Objects.equals(this.samlTestConfiguration, testInfo.samlTestConfiguration)
                && Objects.equals(this.testAccount, testInfo.testAccount);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(escalationSupportContact, oidcTestConfiguration, samlTestConfiguration, testAccount);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfo {\n");
        sb.append("    escalationSupportContact: ").append(toIndentedString(escalationSupportContact)).append("\n");
        sb.append("    oidcTestConfiguration: ").append(toIndentedString(oidcTestConfiguration)).append("\n");
        sb.append("    samlTestConfiguration: ").append(toIndentedString(samlTestConfiguration)).append("\n");
        sb.append("    testAccount: ").append(toIndentedString(testAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
