package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.BaseContextSession;
import com.okta.sdk.resource.model.BaseContextUser;
import com.okta.sdk.resource.model.InlineHookRequestObject;
import com.okta.sdk.resource.model.TokenPayLoadDataContextAllOfPolicy;
import com.okta.sdk.resource.model.TokenPayLoadDataContextAllOfProtocol;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TokenPayLoadDataContext
 */
@JsonPropertyOrder({ TokenPayLoadDataContext.JSON_PROPERTY_REQUEST, TokenPayLoadDataContext.JSON_PROPERTY_SESSION,
        TokenPayLoadDataContext.JSON_PROPERTY_USER, TokenPayLoadDataContext.JSON_PROPERTY_PROTOCOL,
        TokenPayLoadDataContext.JSON_PROPERTY_POLICY })
@JsonTypeName("TokenPayLoad_data_context")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class TokenPayLoadDataContext implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_REQUEST = "request";
    private InlineHookRequestObject request;

    public static final String JSON_PROPERTY_SESSION = "session";
    private BaseContextSession session;

    public static final String JSON_PROPERTY_USER = "user";
    private BaseContextUser user;

    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private TokenPayLoadDataContextAllOfProtocol protocol;

    public static final String JSON_PROPERTY_POLICY = "policy";
    private TokenPayLoadDataContextAllOfPolicy policy;

    public TokenPayLoadDataContext() {
    }

    public TokenPayLoadDataContext request(InlineHookRequestObject request) {

        this.request = request;
        return this;
    }

    /**
     * Get request
     *
     * @return request
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public InlineHookRequestObject getRequest() {
        return request;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequest(InlineHookRequestObject request) {
        this.request = request;
    }

    public TokenPayLoadDataContext session(BaseContextSession session) {

        this.session = session;
        return this;
    }

    /**
     * Get session
     *
     * @return session
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextSession getSession() {
        return session;
    }

    @JsonProperty(JSON_PROPERTY_SESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSession(BaseContextSession session) {
        this.session = session;
    }

    public TokenPayLoadDataContext user(BaseContextUser user) {

        this.user = user;
        return this;
    }

    /**
     * Get user
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextUser getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(BaseContextUser user) {
        this.user = user;
    }

    public TokenPayLoadDataContext protocol(TokenPayLoadDataContextAllOfProtocol protocol) {

        this.protocol = protocol;
        return this;
    }

    /**
     * Get protocol
     *
     * @return protocol
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROTOCOL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataContextAllOfProtocol getProtocol() {
        return protocol;
    }

    @JsonProperty(JSON_PROPERTY_PROTOCOL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProtocol(TokenPayLoadDataContextAllOfProtocol protocol) {
        this.protocol = protocol;
    }

    public TokenPayLoadDataContext policy(TokenPayLoadDataContextAllOfPolicy policy) {

        this.policy = policy;
        return this;
    }

    /**
     * Get policy
     *
     * @return policy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_POLICY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataContextAllOfPolicy getPolicy() {
        return policy;
    }

    @JsonProperty(JSON_PROPERTY_POLICY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(TokenPayLoadDataContextAllOfPolicy policy) {
        this.policy = policy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataContext tokenPayLoadDataContext = (TokenPayLoadDataContext) o;
        return Objects.equals(this.request, tokenPayLoadDataContext.request)
                && Objects.equals(this.session, tokenPayLoadDataContext.session)
                && Objects.equals(this.user, tokenPayLoadDataContext.user)
                && Objects.equals(this.protocol, tokenPayLoadDataContext.protocol)
                && Objects.equals(this.policy, tokenPayLoadDataContext.policy);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(request, session, user, protocol, policy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataContext {\n");
        sb.append("    request: ").append(toIndentedString(request)).append("\n");
        sb.append("    session: ").append(toIndentedString(session)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("    protocol: ").append(toIndentedString(protocol)).append("\n");
        sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
