package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserCredentials;
import com.okta.sdk.resource.model.UserProfile;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UpdateUserRequest
 */
@JsonPropertyOrder({ UpdateUserRequest.JSON_PROPERTY_CREDENTIALS, UpdateUserRequest.JSON_PROPERTY_PROFILE,
        UpdateUserRequest.JSON_PROPERTY_REALM_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UpdateUserRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private UserCredentials credentials;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private UserProfile profile;

    public static final String JSON_PROPERTY_REALM_ID = "realmId";
    private String realmId;

    public UpdateUserRequest() {
    }

    public UpdateUserRequest credentials(UserCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(UserCredentials credentials) {
        this.credentials = credentials;
    }

    public UpdateUserRequest profile(UserProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(UserProfile profile) {
        this.profile = profile;
    }

    public UpdateUserRequest realmId(String realmId) {

        this.realmId = realmId;
        return this;
    }

    /**
     * &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;The ID of the Realm in which the User is residing
     *
     * @return realmId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "guo1bfiNtSnZYILxO0g4", value = "<div class=\"x-lifecycle-container\"><x-lifecycle class=\"ea\"></x-lifecycle></div>The ID of the Realm in which the User is residing")
    @JsonProperty(JSON_PROPERTY_REALM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRealmId() {
        return realmId;
    }

    @JsonProperty(JSON_PROPERTY_REALM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateUserRequest updateUserRequest = (UpdateUserRequest) o;
        return Objects.equals(this.credentials, updateUserRequest.credentials)
                && Objects.equals(this.profile, updateUserRequest.profile)
                && Objects.equals(this.realmId, updateUserRequest.realmId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credentials, profile, realmId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateUserRequest {\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    realmId: ").append(toIndentedString(realmId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
