package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UploadYubikeyOtpTokenSeedRequest
 */
@JsonPropertyOrder({ UploadYubikeyOtpTokenSeedRequest.JSON_PROPERTY_SERIAL_NUMBER,
        UploadYubikeyOtpTokenSeedRequest.JSON_PROPERTY_PUBLIC_ID,
        UploadYubikeyOtpTokenSeedRequest.JSON_PROPERTY_PRIVATE_ID,
        UploadYubikeyOtpTokenSeedRequest.JSON_PROPERTY_AES_KEY })
@JsonTypeName("uploadYubikeyOtpTokenSeed_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UploadYubikeyOtpTokenSeedRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
    private String serialNumber;

    public static final String JSON_PROPERTY_PUBLIC_ID = "publicId";
    private String publicId;

    public static final String JSON_PROPERTY_PRIVATE_ID = "privateId";
    private String privateId;

    public static final String JSON_PROPERTY_AES_KEY = "aesKey";
    private String aesKey;

    public UploadYubikeyOtpTokenSeedRequest() {
    }

    public UploadYubikeyOtpTokenSeedRequest serialNumber(String serialNumber) {

        this.serialNumber = serialNumber;
        return this;
    }

    /**
     * The unique identifier assigned to each YubiKey device
     *
     * @return serialNumber
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique identifier assigned to each YubiKey device")
    @JsonProperty(JSON_PROPERTY_SERIAL_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSerialNumber() {
        return serialNumber;
    }

    @JsonProperty(JSON_PROPERTY_SERIAL_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public UploadYubikeyOtpTokenSeedRequest publicId(String publicId) {

        this.publicId = publicId;
        return this;
    }

    /**
     * The Yubikey&#39;s public ID
     *
     * @return publicId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Yubikey's public ID")
    @JsonProperty(JSON_PROPERTY_PUBLIC_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPublicId() {
        return publicId;
    }

    @JsonProperty(JSON_PROPERTY_PUBLIC_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public UploadYubikeyOtpTokenSeedRequest privateId(String privateId) {

        this.privateId = privateId;
        return this;
    }

    /**
     * The Yubikey&#39;s private ID
     *
     * @return privateId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Yubikey's private ID")
    @JsonProperty(JSON_PROPERTY_PRIVATE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPrivateId() {
        return privateId;
    }

    @JsonProperty(JSON_PROPERTY_PRIVATE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPrivateId(String privateId) {
        this.privateId = privateId;
    }

    public UploadYubikeyOtpTokenSeedRequest aesKey(String aesKey) {

        this.aesKey = aesKey;
        return this;
    }

    /**
     * The cryptographic key used in the AES algorithm to encrypt and decrypt YubiKey OTP
     *
     * @return aesKey
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The cryptographic key used in the AES algorithm to encrypt and decrypt YubiKey OTP")
    @JsonProperty(JSON_PROPERTY_AES_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAesKey() {
        return aesKey;
    }

    @JsonProperty(JSON_PROPERTY_AES_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UploadYubikeyOtpTokenSeedRequest uploadYubikeyOtpTokenSeedRequest = (UploadYubikeyOtpTokenSeedRequest) o;
        return Objects.equals(this.serialNumber, uploadYubikeyOtpTokenSeedRequest.serialNumber)
                && Objects.equals(this.publicId, uploadYubikeyOtpTokenSeedRequest.publicId)
                && Objects.equals(this.privateId, uploadYubikeyOtpTokenSeedRequest.privateId)
                && Objects.equals(this.aesKey, uploadYubikeyOtpTokenSeedRequest.aesKey);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(serialNumber, publicId, privateId, aesKey);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadYubikeyOtpTokenSeedRequest {\n");
        sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
        sb.append("    publicId: ").append(toIndentedString(publicId)).append("\n");
        sb.append("    privateId: ").append(toIndentedString(privateId)).append("\n");
        sb.append("    aesKey: ").append(toIndentedString(aesKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
