package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorCallProfile
 */
@JsonPropertyOrder({ UserFactorCallProfile.JSON_PROPERTY_PHONE_EXTENSION,
        UserFactorCallProfile.JSON_PROPERTY_PHONE_NUMBER })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UserFactorCallProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PHONE_EXTENSION = "phoneExtension";
    private JsonNullable<String> phoneExtension = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;

    public UserFactorCallProfile() {
    }

    public UserFactorCallProfile phoneExtension(String phoneExtension) {
        this.phoneExtension = JsonNullable.<String> of(phoneExtension);

        return this;
    }

    /**
     * Extension of the associated &#x60;phoneNumber&#x60;
     *
     * @return phoneExtension
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "1234", value = "Extension of the associated `phoneNumber`")
    @JsonIgnore

    public String getPhoneExtension() {
        return phoneExtension.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_PHONE_EXTENSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getPhoneExtension_JsonNullable() {
        return phoneExtension;
    }

    @JsonProperty(JSON_PROPERTY_PHONE_EXTENSION)
    public void setPhoneExtension_JsonNullable(JsonNullable<String> phoneExtension) {
        this.phoneExtension = phoneExtension;
    }

    public void setPhoneExtension(String phoneExtension) {
        this.phoneExtension = JsonNullable.<String> of(phoneExtension);
    }

    public UserFactorCallProfile phoneNumber(String phoneNumber) {

        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * Phone number of the Factor. Format phone numbers to use the [E.164
     * standard](https://www.itu.int/rec/T-REC-E.164/).
     *
     * @return phoneNumber
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "+15554151337", value = "Phone number of the Factor. Format phone numbers to use the [E.164 standard](https://www.itu.int/rec/T-REC-E.164/).")
    @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPhoneNumber() {
        return phoneNumber;
    }

    @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorCallProfile userFactorCallProfile = (UserFactorCallProfile) o;
        return equalsNullable(this.phoneExtension, userFactorCallProfile.phoneExtension)
                && Objects.equals(this.phoneNumber, userFactorCallProfile.phoneNumber);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(phoneExtension), phoneNumber);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorCallProfile {\n");
        sb.append("    phoneExtension: ").append(toIndentedString(phoneExtension)).append("\n");
        sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
