package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * WellKnownOrgMetadataSettings
 */
@JsonPropertyOrder({ WellKnownOrgMetadataSettings.JSON_PROPERTY_ANALYTICS_COLLECTION_ENABLED,
        WellKnownOrgMetadataSettings.JSON_PROPERTY_BUG_REPORTING_ENABLED,
        WellKnownOrgMetadataSettings.JSON_PROPERTY_OM_ENABLED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class WellKnownOrgMetadataSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ANALYTICS_COLLECTION_ENABLED = "analyticsCollectionEnabled";
    private Boolean analyticsCollectionEnabled;

    public static final String JSON_PROPERTY_BUG_REPORTING_ENABLED = "bugReportingEnabled";
    private Boolean bugReportingEnabled;

    public static final String JSON_PROPERTY_OM_ENABLED = "omEnabled";
    private Boolean omEnabled;

    public WellKnownOrgMetadataSettings() {
    }

    public WellKnownOrgMetadataSettings analyticsCollectionEnabled(Boolean analyticsCollectionEnabled) {

        this.analyticsCollectionEnabled = analyticsCollectionEnabled;
        return this;
    }

    /**
     * Get analyticsCollectionEnabled
     *
     * @return analyticsCollectionEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ANALYTICS_COLLECTION_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAnalyticsCollectionEnabled() {
        return analyticsCollectionEnabled;
    }

    @JsonProperty(JSON_PROPERTY_ANALYTICS_COLLECTION_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAnalyticsCollectionEnabled(Boolean analyticsCollectionEnabled) {
        this.analyticsCollectionEnabled = analyticsCollectionEnabled;
    }

    public WellKnownOrgMetadataSettings bugReportingEnabled(Boolean bugReportingEnabled) {

        this.bugReportingEnabled = bugReportingEnabled;
        return this;
    }

    /**
     * Get bugReportingEnabled
     *
     * @return bugReportingEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BUG_REPORTING_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getBugReportingEnabled() {
        return bugReportingEnabled;
    }

    @JsonProperty(JSON_PROPERTY_BUG_REPORTING_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBugReportingEnabled(Boolean bugReportingEnabled) {
        this.bugReportingEnabled = bugReportingEnabled;
    }

    public WellKnownOrgMetadataSettings omEnabled(Boolean omEnabled) {

        this.omEnabled = omEnabled;
        return this;
    }

    /**
     * Whether the legacy Okta Mobile application is enabled for the org
     *
     * @return omEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Whether the legacy Okta Mobile application is enabled for the org")
    @JsonProperty(JSON_PROPERTY_OM_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getOmEnabled() {
        return omEnabled;
    }

    @JsonProperty(JSON_PROPERTY_OM_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOmEnabled(Boolean omEnabled) {
        this.omEnabled = omEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WellKnownOrgMetadataSettings wellKnownOrgMetadataSettings = (WellKnownOrgMetadataSettings) o;
        return Objects.equals(this.analyticsCollectionEnabled, wellKnownOrgMetadataSettings.analyticsCollectionEnabled)
                && Objects.equals(this.bugReportingEnabled, wellKnownOrgMetadataSettings.bugReportingEnabled)
                && Objects.equals(this.omEnabled, wellKnownOrgMetadataSettings.omEnabled);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(analyticsCollectionEnabled, bugReportingEnabled, omEnabled);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WellKnownOrgMetadataSettings {\n");
        sb.append("    analyticsCollectionEnabled: ").append(toIndentedString(analyticsCollectionEnabled)).append("\n");
        sb.append("    bugReportingEnabled: ").append(toIndentedString(bugReportingEnabled)).append("\n");
        sb.append("    omEnabled: ").append(toIndentedString(omEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
