

# AppUser

The Application User object defines a user's app-specific profile and credentials for an app

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**created** | [**OffsetDateTime**](OffsetDateTime.md) |  |  [optional] |
|**credentials** | [**AppUserCredentials**](AppUserCredentials.md) |  |  [optional] |
|**externalId** | **String** | The ID of the user in the target app that&#39;s linked to the Okta Application User object. This value is the native app-specific identifier or primary key for the user in the target app.  The &#x60;externalId&#x60; is set during import when the user is confirmed (reconciled) or during provisioning when the user is created in the target app. This value isn&#39;t populated for SSO app assignments (for example, SAML or SWA) because it isn&#39;t synchronized with a target app. |  [optional] [readonly] |
|**id** | **String** | Unique identifier for the Okta User |  [optional] |
|**lastSync** | **OffsetDateTime** | Timestamp of the last synchronization operation. This value is only updated for apps with the &#x60;IMPORT_PROFILE_UPDATES&#x60; or &#x60;PUSH PROFILE_UPDATES&#x60; feature. |  [optional] [readonly] |
|**lastUpdated** | [**OffsetDateTime**](OffsetDateTime.md) |  |  [optional] |
|**passwordChanged** | **OffsetDateTime** | Timestamp when the Application User password was last changed |  [optional] [readonly] |
|**profile** | **Map&lt;String, Object&gt;** | Specifies the default and custom profile properties for a user. Properties that are visible in the Admin Console for an app assignment can also be assigned through the API. Some properties are reference properties that are imported from the target app and can&#39;t be configured. See [profile](/openapi/okta-management/management/tag/User/#tag/User/operation/getUser!c&#x3D;200&amp;path&#x3D;profile&amp;t&#x3D;response).  |  [optional] |
|**scope** | [**ScopeEnum**](#ScopeEnum) | Indicates if the assignment is direct (&#x60;USER&#x60;) or by group membership (&#x60;GROUP&#x60;). |  [optional] |
|**status** | **AppUserStatus** |  |  [optional] |
|**statusChanged** | **OffsetDateTime** | Timestamp when the Application User status was last changed |  [optional] [readonly] |
|**syncState** | **AppUserSyncState** |  |  [optional] |
|**embedded** | **Map&lt;String, Object&gt;** | Embedded resources related to the Application User using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification |  [optional] [readonly] |
|**links** | [**LinksAppAndUser**](LinksAppAndUser.md) |  |  [optional] |



## Enum: ScopeEnum

| Name | Value |
|---- | -----|
| USER | &quot;USER&quot; |
| GROUP | &quot;GROUP&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |


## Implemented Interfaces

* Serializable


