# DeviceAccessApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getDesktopMFARecoveryPinOrgSetting**](DeviceAccessApi.md#getDesktopMFARecoveryPinOrgSetting) | **GET** /device-access/api/v1/desktop-mfa/recovery-pin-settings | Retrieve the Desktop MFA Recovery PIN Org setting |
| [**replaceDesktopMFARecoveryPinOrgSetting**](DeviceAccessApi.md#replaceDesktopMFARecoveryPinOrgSetting) | **PUT** /device-access/api/v1/desktop-mfa/recovery-pin-settings | Replace the Desktop MFA Recovery PIN Org Setting |



## getDesktopMFARecoveryPinOrgSetting

> DesktopMFARecoveryPinOrgSetting getDesktopMFARecoveryPinOrgSetting()

Retrieve the Desktop MFA Recovery PIN Org setting

Retrieves the status of the Desktop MFA Recovery PIN feature. That is, whether or not the feature is enabled for your org.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.DeviceAccessApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        DeviceAccessApi apiInstance = new DeviceAccessApi(defaultClient);
        try {
            DesktopMFARecoveryPinOrgSetting result = apiInstance.getDesktopMFARecoveryPinOrgSetting();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling DeviceAccessApi#getDesktopMFARecoveryPinOrgSetting");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**DesktopMFARecoveryPinOrgSetting**](DesktopMFARecoveryPinOrgSetting.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceDesktopMFARecoveryPinOrgSetting

> DesktopMFARecoveryPinOrgSetting replaceDesktopMFARecoveryPinOrgSetting(desktopMFARecoveryPinOrgSetting)

Replace the Desktop MFA Recovery PIN Org Setting

Replaces the Desktop MFA Recovery PIN feature for your org

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.DeviceAccessApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        DeviceAccessApi apiInstance = new DeviceAccessApi(defaultClient);
        DesktopMFARecoveryPinOrgSetting desktopMFARecoveryPinOrgSetting = new DesktopMFARecoveryPinOrgSetting(); // DesktopMFARecoveryPinOrgSetting | 
        try {
            DesktopMFARecoveryPinOrgSetting result = apiInstance.replaceDesktopMFARecoveryPinOrgSetting(desktopMFARecoveryPinOrgSetting);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling DeviceAccessApi#replaceDesktopMFARecoveryPinOrgSetting");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **desktopMFARecoveryPinOrgSetting** | [**DesktopMFARecoveryPinOrgSetting**](DesktopMFARecoveryPinOrgSetting.md)|  | |

### Return type

[**DesktopMFARecoveryPinOrgSetting**](DesktopMFARecoveryPinOrgSetting.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |

