# EmailCustomizationApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**bulkRemoveEmailAddressBounces**](EmailCustomizationApi.md#bulkRemoveEmailAddressBounces) | **POST** /api/v1/org/email/bounces/remove-list | Remove Bounced Emails |



## bulkRemoveEmailAddressBounces

> BouncesRemoveListResult bulkRemoveEmailAddressBounces(bouncesRemoveListObj)

Remove Bounced Emails

Removes emails from an email service bounce list.  The emails submitted in this operation are removed from the bounce list by an asynchronous job. Any email address that passes validation is accepted for the removal process, even if there are other email addresses in the request that failed validation.  &gt; **Note:** If there are validation errors for all email addresses, a &#x60;200 OK&#x60; HTTP status is still returned. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EmailCustomizationApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EmailCustomizationApi apiInstance = new EmailCustomizationApi(defaultClient);
        BouncesRemoveListObj bouncesRemoveListObj = new BouncesRemoveListObj(); // BouncesRemoveListObj | 
        try {
            BouncesRemoveListResult result = apiInstance.bulkRemoveEmailAddressBounces(bouncesRemoveListObj);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EmailCustomizationApi#bulkRemoveEmailAddressBounces");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **bouncesRemoveListObj** | [**BouncesRemoveListObj**](BouncesRemoveListObj.md)|  | [optional] |

### Return type

[**BouncesRemoveListResult**](BouncesRemoveListResult.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |

