

# OpenIdConnectApplicationSettingsClient


## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**applicationType** | **OpenIdConnectApplicationType** |  |  [optional] |
|**backchannelAuthenticationRequestSigningAlg** | [**BackchannelAuthenticationRequestSigningAlgEnum**](#BackchannelAuthenticationRequestSigningAlgEnum) | The signing algorithm for Client-Initiated Backchannel Authentication (CIBA) signed requests using JWT. If this value isn&#39;t set and a JWT-signed request is sent, the request fails. &gt; **Note:** This property appears for clients with &#x60;urn:openid:params:grant-type:ciba&#x60; defined as one of the &#x60;grant_types&#x60;.  |  [optional] |
|**backchannelCustomAuthenticatorId** | **String** | The ID of the custom authenticator that authenticates the user &gt; **Note:** This property appears for clients with &#x60;urn:openid:params:grant-type:ciba&#x60; defined as one of the &#x60;grant_types&#x60;.  |  [optional] |
|**backchannelTokenDeliveryMode** | [**BackchannelTokenDeliveryModeEnum**](#BackchannelTokenDeliveryModeEnum) | The delivery mode for Client-Initiated Backchannel Authentication (CIBA).  Currently, only &#x60;poll&#x60; is supported. &gt; **Note:** This property appears for clients with &#x60;urn:openid:params:grant-type:ciba&#x60; defined as one of the &#x60;grant_types&#x60;.  |  [optional] |
|**clientUri** | **String** | URL string of a web page providing information about the client |  [optional] |
|**consentMethod** | **OpenIdConnectApplicationConsentMethod** |  |  [optional] |
|**dpopBoundAccessTokens** | **Boolean** | Indicates that the client application uses Demonstrating Proof-of-Possession (DPoP) for token requests. If &#x60;true&#x60;, the authorization server rejects token requests from this client that don&#39;t contain the DPoP header. &gt; **Note:** If &#x60;dpop_bound_access_tokens&#x60; is true, then &#x60;client_credentials&#x60; and &#x60;implicit&#x60; aren&#39;t allowed in &#x60;grant_types&#x60;.  |  [optional] |
|**frontchannelLogoutSessionRequired** | **Boolean** | &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;Determines whether Okta sends &#x60;sid&#x60; and &#x60;iss&#x60; in the logout request |  [optional] |
|**frontchannelLogoutUri** | **String** | &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;URL where Okta sends the logout request |  [optional] |
|**grantTypes** | **List&lt;OAuthGrantType&gt;** |  |  |
|**idpInitiatedLogin** | [**OpenIdConnectApplicationIdpInitiatedLogin**](OpenIdConnectApplicationIdpInitiatedLogin.md) |  |  [optional] |
|**initiateLoginUri** | **String** | URL string that a third party can use to initiate the sign-in flow by the client |  [optional] |
|**issuerMode** | **OpenIdConnectApplicationIssuerMode** |  |  [optional] |
|**jwks** | [**OpenIdConnectApplicationSettingsClientKeys**](OpenIdConnectApplicationSettingsClientKeys.md) |  |  [optional] |
|**jwksUri** | **String** | URL string that references a JSON Web Key Set for validating JWTs presented to Okta |  [optional] |
|**logoUri** | **String** | The URL string that references a logo for the client. This logo appears on the client tile in the End-User Dashboard. It also appears on the client consent dialog during the client consent flow. |  [optional] |
|**participateSlo** | **Boolean** | &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;Allows the app to participate in front-channel Single Logout  &gt; **Note:** You can only enable &#x60;participate_slo&#x60; for &#x60;web&#x60; and &#x60;browser&#x60; application types (&#x60;application_type&#x60;).  |  [optional] |
|**policyUri** | **String** | URL string of a web page providing the client&#39;s policy document |  [optional] |
|**postLogoutRedirectUris** | **List&lt;String&gt;** | Array of redirection URI strings for relying party-initiated logouts |  [optional] |
|**redirectUris** | **List&lt;String&gt;** | Array of redirection URI strings for use in redirect-based flows. &gt; **Note:** At least one &#x60;redirect_uris&#x60; and &#x60;response_types&#x60; are required for all client types, with exceptions: if the client uses the [Resource Owner Password ](https://tools.ietf.org/html/rfc6749#section-4.3)flow (&#x60;grant_types&#x60; contains &#x60;password&#x60;) or [Client Credentials](https://tools.ietf.org/html/rfc6749#section-4.4)flow (&#x60;grant_types&#x60; contains &#x60;client_credentials&#x60;), then no &#x60;redirect_uris&#x60; or &#x60;response_types&#x60; is necessary. In these cases, you can pass either null or an empty array for these attributes. |  [optional] |
|**refreshToken** | [**OpenIdConnectApplicationSettingsRefreshToken**](OpenIdConnectApplicationSettingsRefreshToken.md) |  |  [optional] |
|**requestObjectSigningAlg** | [**RequestObjectSigningAlgEnum**](#RequestObjectSigningAlgEnum) | The type of JSON Web Key Set (JWKS) algorithm that must be used for signing request objects |  [optional] |
|**responseTypes** | **List&lt;OAuthResponseType&gt;** | Array of OAuth 2.0 response type strings |  [optional] |
|**sectorIdentifierUri** | **String** | The sector identifier used for pairwise &#x60;subject_type&#x60;. See [OIDC Pairwise Identifier Algorithm](https://openid.net/specs/openid-connect-messages-1_0-20.html#idtype.pairwise.alg) |  [optional] |
|**subjectType** | [**SubjectTypeEnum**](#SubjectTypeEnum) | Type of the subject |  [optional] |
|**tosUri** | **String** | URL string of a web page providing the client&#39;s terms of service document |  [optional] |
|**wildcardRedirect** | [**WildcardRedirectEnum**](#WildcardRedirectEnum) | Indicates if the client is allowed to use wildcard matching of &#x60;redirect_uris&#x60; |  [optional] |



## Enum: BackchannelAuthenticationRequestSigningAlgEnum

| Name | Value |
|---- | -----|
| HS256 | &quot;HS256&quot; |
| HS384 | &quot;HS384&quot; |
| HS512 | &quot;HS512&quot; |
| RS256 | &quot;RS256&quot; |
| RS384 | &quot;RS384&quot; |
| RS512 | &quot;RS512&quot; |
| ES256 | &quot;ES256&quot; |
| ES384 | &quot;ES384&quot; |
| ES512 | &quot;ES512&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |



## Enum: BackchannelTokenDeliveryModeEnum

| Name | Value |
|---- | -----|
| POLL | &quot;poll&quot; |
| PING | &quot;ping&quot; |
| PUSH | &quot;push&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |



## Enum: RequestObjectSigningAlgEnum

| Name | Value |
|---- | -----|
| HS256 | &quot;HS256&quot; |
| HS384 | &quot;HS384&quot; |
| HS512 | &quot;HS512&quot; |
| RS256 | &quot;RS256&quot; |
| RS384 | &quot;RS384&quot; |
| RS512 | &quot;RS512&quot; |
| ES256 | &quot;ES256&quot; |
| ES384 | &quot;ES384&quot; |
| ES512 | &quot;ES512&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |



## Enum: SubjectTypeEnum

| Name | Value |
|---- | -----|
| PUBLIC | &quot;public&quot; |
| PAIRWISE | &quot;pairwise&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |



## Enum: WildcardRedirectEnum

| Name | Value |
|---- | -----|
| DISABLED | &quot;DISABLED&quot; |
| SUBDOMAIN | &quot;SUBDOMAIN&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |


## Implemented Interfaces

* Serializable


