# SsfTransmitterApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createSsfStream**](SsfTransmitterApi.md#createSsfStream) | **POST** /api/v1/ssf/stream | Create an SSF Stream |
| [**deleteSsfStream**](SsfTransmitterApi.md#deleteSsfStream) | **DELETE** /api/v1/ssf/stream | Delete an SSF Stream |
| [**getSsfStreams**](SsfTransmitterApi.md#getSsfStreams) | **GET** /api/v1/ssf/stream | Retrieve the SSF Stream configuration(s) |
| [**getWellknownSsfMetadata**](SsfTransmitterApi.md#getWellknownSsfMetadata) | **GET** /.well-known/ssf-configuration | Retrieve the SSF Transmitter metadata |
| [**replaceSsfStream**](SsfTransmitterApi.md#replaceSsfStream) | **PUT** /api/v1/ssf/stream | Replace an SSF Stream |
| [**updateSsfStream**](SsfTransmitterApi.md#updateSsfStream) | **PATCH** /api/v1/ssf/stream | Update an SSF Stream |



## createSsfStream

> StreamConfiguration createSsfStream(instance)

Create an SSF Stream

Creates an SSF Stream for an event receiver to start receiving security events in the form of Security Event Tokens (SETs) from Okta.  An SSF Stream is associated with the Client ID of the OAuth 2.0 access token used to create the stream. The Client ID is provided by Okta for an [OAuth 2.0 app integration](https://help.okta.com/okta_help.htm?id&#x3D;ext_Apps_App_Integration_Wizard-oidc). One SSF Stream is allowed for each Client ID, hence, one SSF Stream is allowed for each app integration in Okta.  A maximum of 10 SSF Stream configurations can be created for one org.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfTransmitterApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfTransmitterApi apiInstance = new SsfTransmitterApi(defaultClient);
        StreamConfigurationCreateRequest instance = new StreamConfigurationCreateRequest(); // StreamConfigurationCreateRequest | 
        try {
            StreamConfiguration result = apiInstance.createSsfStream(instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfTransmitterApi#createSsfStream");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **instance** | [**StreamConfigurationCreateRequest**](StreamConfigurationCreateRequest.md)|  | |

### Return type

[**StreamConfiguration**](StreamConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deleteSsfStream

> deleteSsfStream(streamId)

Delete an SSF Stream

Deletes the specified SSF Stream.  If the &#x60;stream_id&#x60; is not provided in the query string, the associated stream with the Client ID (through the request OAuth 2.0 access token) is deleted. Otherwise, the SSF Stream with the &#x60;stream_id&#x60; is deleted, if found.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfTransmitterApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfTransmitterApi apiInstance = new SsfTransmitterApi(defaultClient);
        String streamId = "esc1k235GIIztAuGK0g5"; // String | The ID of the specified SSF Stream configuration
        try {
            apiInstance.deleteSsfStream(streamId);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfTransmitterApi#deleteSsfStream");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **streamId** | **String**| The ID of the specified SSF Stream configuration | [optional] |

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **400** | Bad Request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getSsfStreams

> GetSsfStreams200Response getSsfStreams(streamId)

Retrieve the SSF Stream configuration(s)

Retrieves either a list of all known SSF Stream configurations or the individual configuration if specified by ID.  As Stream configurations are tied to a Client ID, only the Stream associated with the Client ID of the request OAuth 2.0 access token can be viewed.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfTransmitterApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfTransmitterApi apiInstance = new SsfTransmitterApi(defaultClient);
        String streamId = "esc1k235GIIztAuGK0g5"; // String | The ID of the specified SSF Stream configuration
        try {
            GetSsfStreams200Response result = apiInstance.getSsfStreams(streamId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfTransmitterApi#getSsfStreams");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **streamId** | **String**| The ID of the specified SSF Stream configuration | [optional] |

### Return type

[**GetSsfStreams200Response**](GetSsfStreams200Response.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getWellknownSsfMetadata

> WellKnownSSFMetadata getWellknownSsfMetadata()

Retrieve the SSF Transmitter metadata

Retrieves SSF Transmitter configuration metadata. This includes all supported endpoints and key information about certain properties of the Okta org as the transmitter, such as &#x60;delivery_methods_supported&#x60;, &#x60;issuer&#x60;, and &#x60;jwks_uri&#x60;.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfTransmitterApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");

        SsfTransmitterApi apiInstance = new SsfTransmitterApi(defaultClient);
        try {
            WellKnownSSFMetadata result = apiInstance.getWellknownSsfMetadata();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfTransmitterApi#getWellknownSsfMetadata");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**WellKnownSSFMetadata**](WellKnownSSFMetadata.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## replaceSsfStream

> StreamConfiguration replaceSsfStream(instance)

Replace an SSF Stream

Replaces all properties for an existing SSF Stream configuration.  If the &#x60;stream_id&#x60; isn&#39;t provided in the request body, the associated stream with the Client ID (through the request OAuth 2.0 access token) is replaced.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfTransmitterApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfTransmitterApi apiInstance = new SsfTransmitterApi(defaultClient);
        StreamConfiguration instance = new StreamConfiguration(); // StreamConfiguration | 
        try {
            StreamConfiguration result = apiInstance.replaceSsfStream(instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfTransmitterApi#replaceSsfStream");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **instance** | [**StreamConfiguration**](StreamConfiguration.md)|  | |

### Return type

[**StreamConfiguration**](StreamConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## updateSsfStream

> StreamConfiguration updateSsfStream(instance)

Update an SSF Stream

Updates properties for an existing SSF Stream configuration.  If the &#x60;stream_id&#x60; isn&#39;t provided in the request body, the associated stream with the Client ID (through the request OAuth 2.0 access token) is updated.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfTransmitterApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfTransmitterApi apiInstance = new SsfTransmitterApi(defaultClient);
        StreamConfiguration instance = new StreamConfiguration(); // StreamConfiguration | 
        try {
            StreamConfiguration result = apiInstance.updateSsfStream(instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfTransmitterApi#updateSsfStream");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **instance** | [**StreamConfiguration**](StreamConfiguration.md)|  | |

### Return type

[**StreamConfiguration**](StreamConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

