/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import java.io.File;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ApplicationLogosApi {

    private ApiClient apiClient;

    public ApplicationLogosApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationLogosApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Upload an application Logo Uploads a logo for the app instance. If the app already has a logo, this operation
     * replaces the previous logo. The logo is visible in the Admin Console as an icon for your app instance. If you
     * have one &#x60;appLink&#x60; object configured, this logo also appears in the End-User Dashboard as an icon for
     * your app. &gt; **Note:** If you have multiple &#x60;appLink&#x60; objects, use the Admin Console to add logos for
     * each app link. &gt; You can&#39;t use the API to add logos for multiple app links.
     *
     * @param appId
     *            Application ID (required)
     * @param _file
     *            The image file containing the logo. The file must be in PNG, JPG, SVG, or GIF format, and less than
     *            one MB in size. For best results, use an image with a transparent background and a square dimension of
     *            200 x 200 pixels to prevent upscaling. (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void uploadApplicationLogo(String appId, File _file) throws ApiException {
        this.uploadApplicationLogo(appId, _file, Collections.emptyMap());
    }

    /**
     * Upload an application Logo Uploads a logo for the app instance. If the app already has a logo, this operation
     * replaces the previous logo. The logo is visible in the Admin Console as an icon for your app instance. If you
     * have one &#x60;appLink&#x60; object configured, this logo also appears in the End-User Dashboard as an icon for
     * your app. &gt; **Note:** If you have multiple &#x60;appLink&#x60; objects, use the Admin Console to add logos for
     * each app link. &gt; You can&#39;t use the API to add logos for multiple app links.
     *
     * @param appId
     *            Application ID (required)
     * @param _file
     *            The image file containing the logo. The file must be in PNG, JPG, SVG, or GIF format, and less than
     *            one MB in size. For best results, use an image with a transparent background and a square dimension of
     *            200 x 200 pixels to prevent upscaling. (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void uploadApplicationLogo(String appId, File _file, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling uploadApplicationLogo");
        }

        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadApplicationLogo");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/logo".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        if (_file != null)
            localVarFormParams.put("file", _file);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "multipart/form-data" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
