/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.NetworkZone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class NetworkZoneApi {

    private ApiClient apiClient;

    public NetworkZoneApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworkZoneApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Network Zone Activates a Network Zone by &#x60;zoneId&#x60;
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone activateNetworkZone(String zoneId) throws ApiException {
        return this.activateNetworkZone(zoneId, Collections.emptyMap());
    }

    /**
     * Activate a Network Zone Activates a Network Zone by &#x60;zoneId&#x60;
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone activateNetworkZone(String zoneId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'zoneId' is set
        if (zoneId == null) {
            throw new ApiException(400, "Missing the required parameter 'zoneId' when calling activateNetworkZone");
        }

        // create path and map variables
        String localVarPath = "/api/v1/zones/{zoneId}/lifecycle/activate".replaceAll("\\{" + "zoneId" + "\\}",
                apiClient.escapeString(zoneId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<NetworkZone> localVarReturnType = new TypeReference<NetworkZone>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a Network Zone Creates a Network Zone * For an IP Network Zone, you must define either
     * &#x60;gateways&#x60; or &#x60;proxies&#x60;. * For a Dynamic Network Zone, you must define at least one of the
     * following: &#x60;asns&#x60;, &#x60;locations&#x60;, or &#x60;proxyType&#x60;. * For an Enhanced Dynamic Network
     * Zone, you must define at least one of the following: &#x60;asns&#x60;, &#x60;locations&#x60;, or
     * &#x60;ipServiceCategories&#x60;.
     *
     * @param zone
     *            (required)
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone createNetworkZone(NetworkZone zone) throws ApiException {
        return this.createNetworkZone(zone, Collections.emptyMap());
    }

    /**
     * Create a Network Zone Creates a Network Zone * For an IP Network Zone, you must define either
     * &#x60;gateways&#x60; or &#x60;proxies&#x60;. * For a Dynamic Network Zone, you must define at least one of the
     * following: &#x60;asns&#x60;, &#x60;locations&#x60;, or &#x60;proxyType&#x60;. * For an Enhanced Dynamic Network
     * Zone, you must define at least one of the following: &#x60;asns&#x60;, &#x60;locations&#x60;, or
     * &#x60;ipServiceCategories&#x60;.
     *
     * @param zone
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone createNetworkZone(NetworkZone zone, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = zone;

        // verify the required parameter 'zone' is set
        if (zone == null) {
            throw new ApiException(400, "Missing the required parameter 'zone' when calling createNetworkZone");
        }

        // create path and map variables
        String localVarPath = "/api/v1/zones";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<NetworkZone> localVarReturnType = new TypeReference<NetworkZone>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Network Zone Deactivates a Network Zone by &#x60;zoneId&#x60;
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone deactivateNetworkZone(String zoneId) throws ApiException {
        return this.deactivateNetworkZone(zoneId, Collections.emptyMap());
    }

    /**
     * Deactivate a Network Zone Deactivates a Network Zone by &#x60;zoneId&#x60;
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone deactivateNetworkZone(String zoneId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'zoneId' is set
        if (zoneId == null) {
            throw new ApiException(400, "Missing the required parameter 'zoneId' when calling deactivateNetworkZone");
        }

        // create path and map variables
        String localVarPath = "/api/v1/zones/{zoneId}/lifecycle/deactivate".replaceAll("\\{" + "zoneId" + "\\}",
                apiClient.escapeString(zoneId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<NetworkZone> localVarReturnType = new TypeReference<NetworkZone>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Network Zone Deletes a Network Zone by &#x60;zoneId&#x60; &gt; **Notes:** &gt; * You can&#39;t delete a
     * Network Zone that&#39;s used by a
     * [Policy](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Policy/) or
     * [Rule](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Policy/#tag/Policy/operation/listPolicyRules).
     * &gt; * For Okta Identity Engine orgs, you can&#39;t delete a Network Zone with an ACTIVE &#x60;status&#x60;.
     * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteNetworkZone(String zoneId) throws ApiException {
        this.deleteNetworkZone(zoneId, Collections.emptyMap());
    }

    /**
     * Delete a Network Zone Deletes a Network Zone by &#x60;zoneId&#x60; &gt; **Notes:** &gt; * You can&#39;t delete a
     * Network Zone that&#39;s used by a
     * [Policy](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Policy/) or
     * [Rule](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Policy/#tag/Policy/operation/listPolicyRules).
     * &gt; * For Okta Identity Engine orgs, you can&#39;t delete a Network Zone with an ACTIVE &#x60;status&#x60;.
     * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteNetworkZone(String zoneId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'zoneId' is set
        if (zoneId == null) {
            throw new ApiException(400, "Missing the required parameter 'zoneId' when calling deleteNetworkZone");
        }

        // create path and map variables
        String localVarPath = "/api/v1/zones/{zoneId}".replaceAll("\\{" + "zoneId" + "\\}",
                apiClient.escapeString(zoneId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Network Zone Retrieves a Network Zone by &#x60;zoneId&#x60;
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone getNetworkZone(String zoneId) throws ApiException {
        return this.getNetworkZone(zoneId, Collections.emptyMap());
    }

    /**
     * Retrieve a Network Zone Retrieves a Network Zone by &#x60;zoneId&#x60;
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone getNetworkZone(String zoneId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'zoneId' is set
        if (zoneId == null) {
            throw new ApiException(400, "Missing the required parameter 'zoneId' when calling getNetworkZone");
        }

        // create path and map variables
        String localVarPath = "/api/v1/zones/{zoneId}".replaceAll("\\{" + "zoneId" + "\\}",
                apiClient.escapeString(zoneId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<NetworkZone> localVarReturnType = new TypeReference<NetworkZone>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Network Zones Lists all Network Zones with pagination. A subset of zones can be returned that match a
     * supported filter expression or query. This operation requires URL encoding. For example, &#x60;filter&#x3D;(id eq
     * \&quot;nzoul0wf9jyb8xwZm0g3\&quot; or id eq \&quot;nzoul1MxmGN18NDQT0g3\&quot;)&#x60; is encoded as
     * &#x60;filter&#x3D;%28id+eq+%22nzoul0wf9jyb8xwZm0g3%22+or+id+eq+%22nzoul1MxmGN18NDQT0g3%22%29&#x60;. Okta supports
     * filtering on the &#x60;id&#x60; and &#x60;usage&#x60; properties. See
     * [Filtering](https://developer.okta.com/docs/reference/core-okta-api/#filter) for more information on the
     * expressions that are used in filtering.
     *
     * @param after
     *            (optional)
     * @param limit
     *            (optional, default to -1)
     * @param filter
     *            (optional)
     *
     * @return List&lt;NetworkZone&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<NetworkZone> listNetworkZones(String after, Integer limit, String filter) throws ApiException {
        return this.listNetworkZones(after, limit, filter, Collections.emptyMap());
    }

    /**
     * List all Network Zones Lists all Network Zones with pagination. A subset of zones can be returned that match a
     * supported filter expression or query. This operation requires URL encoding. For example, &#x60;filter&#x3D;(id eq
     * \&quot;nzoul0wf9jyb8xwZm0g3\&quot; or id eq \&quot;nzoul1MxmGN18NDQT0g3\&quot;)&#x60; is encoded as
     * &#x60;filter&#x3D;%28id+eq+%22nzoul0wf9jyb8xwZm0g3%22+or+id+eq+%22nzoul1MxmGN18NDQT0g3%22%29&#x60;. Okta supports
     * filtering on the &#x60;id&#x60; and &#x60;usage&#x60; properties. See
     * [Filtering](https://developer.okta.com/docs/reference/core-okta-api/#filter) for more information on the
     * expressions that are used in filtering.
     *
     * @param after
     *            (optional)
     * @param limit
     *            (optional, default to -1)
     * @param filter
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;NetworkZone&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<NetworkZone> listNetworkZones(String after, Integer limit, String filter,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/zones";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<NetworkZone>> localVarReturnType = new TypeReference<List<NetworkZone>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Network Zone Replaces a Network Zone by &#x60;zoneId&#x60;. The replaced Network Zone type must be the
     * same as the existing type. You can replace the usage (&#x60;POLICY&#x60;, &#x60;BLOCKLIST&#x60;) of a Network
     * Zone by updating the &#x60;usage&#x60; attribute.
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     * @param zone
     *            (required)
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone replaceNetworkZone(String zoneId, NetworkZone zone) throws ApiException {
        return this.replaceNetworkZone(zoneId, zone, Collections.emptyMap());
    }

    /**
     * Replace a Network Zone Replaces a Network Zone by &#x60;zoneId&#x60;. The replaced Network Zone type must be the
     * same as the existing type. You can replace the usage (&#x60;POLICY&#x60;, &#x60;BLOCKLIST&#x60;) of a Network
     * Zone by updating the &#x60;usage&#x60; attribute.
     *
     * @param zoneId
     *            &#x60;id&#x60; of the Network Zone (required)
     * @param zone
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return NetworkZone
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public NetworkZone replaceNetworkZone(String zoneId, NetworkZone zone, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = zone;

        // verify the required parameter 'zoneId' is set
        if (zoneId == null) {
            throw new ApiException(400, "Missing the required parameter 'zoneId' when calling replaceNetworkZone");
        }

        // verify the required parameter 'zone' is set
        if (zone == null) {
            throw new ApiException(400, "Missing the required parameter 'zone' when calling replaceNetworkZone");
        }

        // create path and map variables
        String localVarPath = "/api/v1/zones/{zoneId}".replaceAll("\\{" + "zoneId" + "\\}",
                apiClient.escapeString(zoneId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<NetworkZone> localVarReturnType = new TypeReference<NetworkZone>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
