/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateRealmAssignmentRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OperationRequest;
import com.okta.sdk.resource.model.OperationResponse;
import com.okta.sdk.resource.model.RealmAssignment;
import com.okta.sdk.resource.model.UpdateRealmAssignmentRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class RealmAssignmentApi {

    private ApiClient apiClient;

    public RealmAssignmentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RealmAssignmentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Realm Assignment Activates a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateRealmAssignment(String assignmentId) throws ApiException {
        this.activateRealmAssignment(assignmentId, Collections.emptyMap());
    }

    /**
     * Activate a Realm Assignment Activates a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateRealmAssignment(String assignmentId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'assignmentId' is set
        if (assignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignmentId' when calling activateRealmAssignment");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments/{assignmentId}/lifecycle/activate"
                .replaceAll("\\{" + "assignmentId" + "\\}", apiClient.escapeString(assignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Create a Realm Assignment Creates a new Realm Assignment
     *
     * @param body
     *            (required)
     *
     * @return RealmAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RealmAssignment createRealmAssignment(CreateRealmAssignmentRequest body) throws ApiException {
        return this.createRealmAssignment(body, Collections.emptyMap());
    }

    /**
     * Create a Realm Assignment Creates a new Realm Assignment
     *
     * @param body
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RealmAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RealmAssignment createRealmAssignment(CreateRealmAssignmentRequest body,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRealmAssignment");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RealmAssignment> localVarReturnType = new TypeReference<RealmAssignment>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Realm Assignment Deactivates a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateRealmAssignment(String assignmentId) throws ApiException {
        this.deactivateRealmAssignment(assignmentId, Collections.emptyMap());
    }

    /**
     * Deactivate a Realm Assignment Deactivates a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateRealmAssignment(String assignmentId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'assignmentId' is set
        if (assignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignmentId' when calling deactivateRealmAssignment");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments/{assignmentId}/lifecycle/deactivate"
                .replaceAll("\\{" + "assignmentId" + "\\}", apiClient.escapeString(assignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete a Realm Assignment Deletes a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRealmAssignment(String assignmentId) throws ApiException {
        this.deleteRealmAssignment(assignmentId, Collections.emptyMap());
    }

    /**
     * Delete a Realm Assignment Deletes a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRealmAssignment(String assignmentId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'assignmentId' is set
        if (assignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignmentId' when calling deleteRealmAssignment");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments/{assignmentId}".replaceAll("\\{" + "assignmentId" + "\\}",
                apiClient.escapeString(assignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Execute a Realm Assignment Executes a Realm Assignment
     *
     * @param body
     *            (required)
     *
     * @return OperationResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OperationResponse executeRealmAssignment(OperationRequest body) throws ApiException {
        return this.executeRealmAssignment(body, Collections.emptyMap());
    }

    /**
     * Execute a Realm Assignment Executes a Realm Assignment
     *
     * @param body
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OperationResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OperationResponse executeRealmAssignment(OperationRequest body, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling executeRealmAssignment");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments/operations";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OperationResponse> localVarReturnType = new TypeReference<OperationResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Realm Assignment Retrieves a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     *
     * @return RealmAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RealmAssignment getRealmAssignment(String assignmentId) throws ApiException {
        return this.getRealmAssignment(assignmentId, Collections.emptyMap());
    }

    /**
     * Retrieve a Realm Assignment Retrieves a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RealmAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RealmAssignment getRealmAssignment(String assignmentId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'assignmentId' is set
        if (assignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignmentId' when calling getRealmAssignment");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments/{assignmentId}".replaceAll("\\{" + "assignmentId" + "\\}",
                apiClient.escapeString(assignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RealmAssignment> localVarReturnType = new TypeReference<RealmAssignment>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Realm Assignment operations Lists all Realm Assignment operations. The upper limit is 200 and operations
     * are sorted in descending order from most recent to oldest by id
     *
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     *
     * @return List&lt;OperationResponse&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OperationResponse> listRealmAssignmentOperations(Integer limit, String after) throws ApiException {
        return this.listRealmAssignmentOperations(limit, after, Collections.emptyMap());
    }

    /**
     * List all Realm Assignment operations Lists all Realm Assignment operations. The upper limit is 200 and operations
     * are sorted in descending order from most recent to oldest by id
     *
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OperationResponse&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OperationResponse> listRealmAssignmentOperations(Integer limit, String after,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments/operations";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OperationResponse>> localVarReturnType = new TypeReference<List<OperationResponse>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Realm Assignments Lists all Realm Assignments
     *
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     *
     * @return List&lt;RealmAssignment&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<RealmAssignment> listRealmAssignments(Integer limit, String after) throws ApiException {
        return this.listRealmAssignments(limit, after, Collections.emptyMap());
    }

    /**
     * List all Realm Assignments Lists all Realm Assignments
     *
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;RealmAssignment&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<RealmAssignment> listRealmAssignments(Integer limit, String after,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<RealmAssignment>> localVarReturnType = new TypeReference<List<RealmAssignment>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Realm Assignment Replaces a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     * @param body
     *            (required)
     *
     * @return RealmAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RealmAssignment replaceRealmAssignment(String assignmentId, UpdateRealmAssignmentRequest body)
            throws ApiException {
        return this.replaceRealmAssignment(assignmentId, body, Collections.emptyMap());
    }

    /**
     * Replace a Realm Assignment Replaces a Realm Assignment
     *
     * @param assignmentId
     *            &#x60;id&#x60; of the Realm Assignment (required)
     * @param body
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RealmAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RealmAssignment replaceRealmAssignment(String assignmentId, UpdateRealmAssignmentRequest body,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'assignmentId' is set
        if (assignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignmentId' when calling replaceRealmAssignment");
        }

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling replaceRealmAssignment");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realm-assignments/{assignmentId}".replaceAll("\\{" + "assignmentId" + "\\}",
                apiClient.escapeString(assignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RealmAssignment> localVarReturnType = new TypeReference<RealmAssignment>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
