/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateUserRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.UpdateUserRequest;
import com.okta.sdk.resource.model.User;
import com.okta.sdk.resource.model.UserBlock;
import com.okta.sdk.resource.model.UserGetSingleton;
import com.okta.sdk.resource.model.UserNextLogin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UserApi {

    private ApiClient apiClient;

    public UserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a User Creates a new User in your Okta org with or without credentials.&lt;br&gt; &gt; **Legal
     * Disclaimer** &gt; &gt; After a User is added to the Okta directory, they receive an activation email. As part of
     * signing up for this service, &gt; you agreed not to use Okta&#39;s service/product to spam and/or send
     * unsolicited messages. &gt; Please refrain from adding unrelated accounts to the directory as Okta is not
     * responsible for, and disclaims any and all &gt; liability associated with, the activation email&#39;s content.
     * You, and you alone, bear responsibility for the emails sent to any recipients. All responses return the created
     * User. Activation of a User is an asynchronous operation. The system performs group reconciliation during
     * activation and assigns the User to all apps via direct or indirect relationships (group memberships). * The
     * user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;ACTIVE&#x60; during activation to indicate that
     * the User hasn&#39;t completed the asynchronous operation. * The user&#39;s &#x60;status&#x60; is
     * &#x60;ACTIVE&#x60; when the activation process is complete. The User is emailed a one-time activation token if
     * activated without a password. &gt; **Note:** If the User is assigned to an app that is configured for
     * provisioning, the activation process triggers downstream provisioning to the app. It is possible for a User to
     * sign in before these apps have been successfully provisioned for the User. &gt; **Important:** Do not generate or
     * send a one-time activation token when activating Users with an assigned password. Users should sign in with their
     * assigned password. For more information about the various scenarios of creating a user listed in the examples,
     * see User Scenario Creations section in the [Users API](/openapi/okta-management/management/tag/User) description.
     *
     * @param body
     *            (required)
     * @param activate
     *            Executes an [activation
     *            lifecycle](/openapi/okta-management/management/tag/UserLifecycle/#tag/UserLifecycle/operation/activateUser)
     *            operation when creating the User (optional, default to true)
     * @param provider
     *            Indicates whether to create a User with a specified authentication provider (optional, default to
     *            false)
     * @param nextLogin
     *            With &#x60;activate&#x3D;true&#x60;, if &#x60;nextLogin&#x3D;changePassword&#x60;, a User is created,
     *            activated, and the password is set to &#x60;EXPIRED&#x60;. The User must change it the next time they
     *            sign in. (optional)
     *
     * @return User
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public User createUser(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin)
            throws ApiException {
        return this.createUser(body, activate, provider, nextLogin, Collections.emptyMap());
    }

    /**
     * Create a User Creates a new User in your Okta org with or without credentials.&lt;br&gt; &gt; **Legal
     * Disclaimer** &gt; &gt; After a User is added to the Okta directory, they receive an activation email. As part of
     * signing up for this service, &gt; you agreed not to use Okta&#39;s service/product to spam and/or send
     * unsolicited messages. &gt; Please refrain from adding unrelated accounts to the directory as Okta is not
     * responsible for, and disclaims any and all &gt; liability associated with, the activation email&#39;s content.
     * You, and you alone, bear responsibility for the emails sent to any recipients. All responses return the created
     * User. Activation of a User is an asynchronous operation. The system performs group reconciliation during
     * activation and assigns the User to all apps via direct or indirect relationships (group memberships). * The
     * user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;ACTIVE&#x60; during activation to indicate that
     * the User hasn&#39;t completed the asynchronous operation. * The user&#39;s &#x60;status&#x60; is
     * &#x60;ACTIVE&#x60; when the activation process is complete. The User is emailed a one-time activation token if
     * activated without a password. &gt; **Note:** If the User is assigned to an app that is configured for
     * provisioning, the activation process triggers downstream provisioning to the app. It is possible for a User to
     * sign in before these apps have been successfully provisioned for the User. &gt; **Important:** Do not generate or
     * send a one-time activation token when activating Users with an assigned password. Users should sign in with their
     * assigned password. For more information about the various scenarios of creating a user listed in the examples,
     * see User Scenario Creations section in the [Users API](/openapi/okta-management/management/tag/User) description.
     *
     * @param body
     *            (required)
     * @param activate
     *            Executes an [activation
     *            lifecycle](/openapi/okta-management/management/tag/UserLifecycle/#tag/UserLifecycle/operation/activateUser)
     *            operation when creating the User (optional, default to true)
     * @param provider
     *            Indicates whether to create a User with a specified authentication provider (optional, default to
     *            false)
     * @param nextLogin
     *            With &#x60;activate&#x3D;true&#x60;, if &#x60;nextLogin&#x3D;changePassword&#x60;, a User is created,
     *            activated, and the password is set to &#x60;EXPIRED&#x60;. The User must change it the next time they
     *            sign in. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return User
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public User createUser(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("activate", activate));
        localVarQueryParams.addAll(apiClient.parameterToPair("provider", provider));
        localVarQueryParams.addAll(apiClient.parameterToPair("nextLogin", nextLogin));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<User> localVarReturnType = new TypeReference<User>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a User Deletes a User permanently. This operation can only be performed on Users that have a
     * &#x60;DEPROVISIONED&#x60; status. **This action can&#39;t be recovered!** This operation on a User that
     * hasn&#39;t been deactivated causes that User to be deactivated. A second delete operation is required to delete
     * the User. &gt; **Note:** You can also perform user deletion asynchronously. To invoke asynchronous user deletion,
     * pass an HTTP header &#x60;Prefer: respond-async&#x60; with the request. This header is also supported by user
     * deactivation, which is performed if the delete endpoint is invoked on a User that hasn&#39;t been deactivated.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param sendEmail
     *            Sends a deactivation email to the admin if &#x60;true&#x60; (optional, default to false)
     * @param prefer
     *            (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteUser(String id, Boolean sendEmail, String prefer) throws ApiException {
        this.deleteUser(id, sendEmail, prefer, Collections.emptyMap());
    }

    /**
     * Delete a User Deletes a User permanently. This operation can only be performed on Users that have a
     * &#x60;DEPROVISIONED&#x60; status. **This action can&#39;t be recovered!** This operation on a User that
     * hasn&#39;t been deactivated causes that User to be deactivated. A second delete operation is required to delete
     * the User. &gt; **Note:** You can also perform user deletion asynchronously. To invoke asynchronous user deletion,
     * pass an HTTP header &#x60;Prefer: respond-async&#x60; with the request. This header is also supported by user
     * deactivation, which is performed if the delete endpoint is invoked on a User that hasn&#39;t been deactivated.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param sendEmail
     *            Sends a deactivation email to the admin if &#x60;true&#x60; (optional, default to false)
     * @param prefer
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteUser(String id, Boolean sendEmail, String prefer, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("sendEmail", sendEmail));
        if (prefer != null)
            localVarHeaderParams.put("Prefer", apiClient.parameterToString(prefer));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a User Retrieves a User from your Okta org. &gt; **Note:** You can substitute &#x60;me&#x60; for the
     * &#x60;id&#x60; to fetch the current User linked to an API token or session cookie. &gt; * The request returns the
     * User linked to the API token that is specified in the Authorization header, not the User linked to the active
     * session. Details of the Admin User who granted the API token is returned. &gt; * When the end User has an active
     * Okta session, it is typically a CORS request from the browser. Therefore, it&#39;s possible to retrieve the
     * current User without the Authorization header. &gt; **Note:** Some browsers block third-party cookies by default,
     * which disrupts Okta functionality in certain flows. See [Mitigate the impact of third-party cookie
     * deprecation](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-third-party-cookies). &gt;
     * **Note:** When fetching a User by &#x60;login&#x60; or &#x60;login shortname&#x60;, [URL
     * encode](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding) the request parameter to ensure that
     * special characters are escaped properly. Logins with a &#x60;/&#x60; character can only be fetched by
     * &#x60;id&#x60; due to URL issues with escaping the &#x60;/&#x60; character.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param contentType
     *            Specifies the media type of the resource. Optional &#x60;okta-response&#x60; value can be included for
     *            performance optimization. Complex DelAuth configurations may degrade performance when fetching
     *            specific parts of the response, and passing this parameter can omit these parts, bypassing the
     *            bottleneck. Enum values for &#x60;okta-response&#x60;: * &#x60;omitCredentials&#x60;: Omits the
     *            credentials subobject from the response. * &#x60;omitCredentialsLinks&#x60;: Omits the following HAL
     *            links from the response: Change Password, Change Recovery Question, Forgot Password, Reset Password,
     *            Reset Factors, Unlock. * &#x60;omitTransitioningToStatus&#x60;: Omits the
     *            &#x60;transitioningToStatus&#x60; field from the response. (optional)
     * @param expand
     *            An optional parameter to include metadata in the &#x60;_embedded&#x60; attribute. Valid value:
     *            &#x60;blocks&#x60; (optional)
     *
     * @return UserGetSingleton
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserGetSingleton getUser(String id, String contentType, String expand) throws ApiException {
        return this.getUser(id, contentType, expand, Collections.emptyMap());
    }

    /**
     * Retrieve a User Retrieves a User from your Okta org. &gt; **Note:** You can substitute &#x60;me&#x60; for the
     * &#x60;id&#x60; to fetch the current User linked to an API token or session cookie. &gt; * The request returns the
     * User linked to the API token that is specified in the Authorization header, not the User linked to the active
     * session. Details of the Admin User who granted the API token is returned. &gt; * When the end User has an active
     * Okta session, it is typically a CORS request from the browser. Therefore, it&#39;s possible to retrieve the
     * current User without the Authorization header. &gt; **Note:** Some browsers block third-party cookies by default,
     * which disrupts Okta functionality in certain flows. See [Mitigate the impact of third-party cookie
     * deprecation](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-third-party-cookies). &gt;
     * **Note:** When fetching a User by &#x60;login&#x60; or &#x60;login shortname&#x60;, [URL
     * encode](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding) the request parameter to ensure that
     * special characters are escaped properly. Logins with a &#x60;/&#x60; character can only be fetched by
     * &#x60;id&#x60; due to URL issues with escaping the &#x60;/&#x60; character.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param contentType
     *            Specifies the media type of the resource. Optional &#x60;okta-response&#x60; value can be included for
     *            performance optimization. Complex DelAuth configurations may degrade performance when fetching
     *            specific parts of the response, and passing this parameter can omit these parts, bypassing the
     *            bottleneck. Enum values for &#x60;okta-response&#x60;: * &#x60;omitCredentials&#x60;: Omits the
     *            credentials subobject from the response. * &#x60;omitCredentialsLinks&#x60;: Omits the following HAL
     *            links from the response: Change Password, Change Recovery Question, Forgot Password, Reset Password,
     *            Reset Factors, Unlock. * &#x60;omitTransitioningToStatus&#x60;: Omits the
     *            &#x60;transitioningToStatus&#x60; field from the response. (optional)
     * @param expand
     *            An optional parameter to include metadata in the &#x60;_embedded&#x60; attribute. Valid value:
     *            &#x60;blocks&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserGetSingleton
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserGetSingleton getUser(String id, String contentType, String expand, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        if (contentType != null)
            localVarHeaderParams.put("Content-Type", apiClient.parameterToString(contentType));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserGetSingleton> localVarReturnType = new TypeReference<UserGetSingleton>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all User Blocks Lists information about how the User is blocked from accessing their account
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return List&lt;UserBlock&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserBlock> listUserBlocks(String userId) throws ApiException {
        return this.listUserBlocks(userId, Collections.emptyMap());
    }

    /**
     * List all User Blocks Lists information about how the User is blocked from accessing their account
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;UserBlock&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserBlock> listUserBlocks(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserBlocks");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/blocks".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<UserBlock>> localVarReturnType = new TypeReference<List<UserBlock>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Users Lists Users in your org, with pagination in most cases. A subset of Users can be returned that
     * match a supported filter expression or search criteria.
     *
     * @param contentType
     *            Specifies the media type of the resource. Optional &#x60;okta-response&#x60; value can be included for
     *            performance optimization. Complex DelAuth configurations may degrade performance when fetching
     *            specific parts of the response, and passing this parameter can omit these parts, bypassing the
     *            bottleneck. Enum values for &#x60;okta-response&#x60;: * &#x60;omitCredentials&#x60;: Omits the
     *            credentials subobject from the response. * &#x60;omitCredentialsLinks&#x60;: Omits the following HAL
     *            links from the response: Change Password, Change Recovery Question, Forgot Password, Reset Password,
     *            Reset Factors, Unlock. * &#x60;omitTransitioningToStatus&#x60;: Omits the
     *            &#x60;transitioningToStatus&#x60; field from the response. (optional)
     * @param q
     *            Finds users who match the specified query. This doesn&#39;t support pagination. This might not deliver
     *            optimal performance for large orgs, and is deprecated for such use cases. To ensure optimal
     *            performance, use a [&#x60;search&#x60;
     *            parameter](/openapi/okta-management/management/tag/User/#tag/User/operation/listUsers!in&#x3D;query&amp;path&#x3D;search&amp;t&#x3D;request)
     *            instead. Use the &#x60;q&#x60; parameter for a simple lookup of users by name, for example when
     *            creating a people picker. The value of &#x60;q&#x60; is matched against &#x60;firstName&#x60;,
     *            &#x60;lastName&#x60;, or &#x60;email&#x60;. This performs a &#x60;startsWith&#x60; match, but this is
     *            an implementation detail and can change without notice. You don&#39;t need to specify
     *            &#x60;firstName&#x60;, &#x60;lastName&#x60;, or &#x60;email&#x60;. (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of results returned. Defaults to 10 if &#x60;q&#x60; is provided. (optional,
     *            default to 200)
     * @param filter
     *            Filters users with a supported expression for a subset of properties. This requires [URL
     *            encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example,
     *            &#x60;filter&#x3D;lastUpdated gt \&quot;2013-06-01T00:00:00.000Z\&quot;&#x60; is encoded as
     *            &#x60;filter&#x3D;lastUpdated%20gt%20%222013-06-01T00:00:00.000Z%22&#x60;. Filtering is case-sensitive
     *            for attribute names and query values, while attribute operators are case-insensitive. Filtering
     *            supports the following limited number of properties: &#x60;status&#x60;, &#x60;lastUpdated&#x60;,
     *            &#x60;id&#x60;, &#x60;profile.login&#x60;, &#x60;profile.email&#x60;, &#x60;profile.firstName&#x60;,
     *            and &#x60;profile.lastName&#x60;. Additionally, filtering supports only the equal &#x60;eq&#x60;
     *            operator from the standard Okta API filtering semantics, except in the case of the
     *            &#x60;lastUpdated&#x60; property. This property can also use the inequality operators (&#x60;gt&#x60;,
     *            &#x60;ge&#x60;, &#x60;lt&#x60;, and &#x60;le&#x60;). For logical operators, only the logical operators
     *            &#x60;and&#x60; and &#x60;or&#x60; are supported. The &#x60;not&#x60; operator isn&#39;t supported.
     *            (optional)
     * @param search
     *            Searches for users with a supported filtering expression for most properties. Okta recommends using
     *            this parameter for search for best performance. This operation supports
     *            [pagination](https://developer.okta.com/docs/api/#pagination). Use an ID lookup for records that you
     *            update to ensure your results contain the latest data. Property names in the search parameter are case
     *            sensitive, whereas operators (&#x60;eq&#x60;, &#x60;sw&#x60;, and so on) and string values are case
     *            insensitive. Unlike with user logins, diacritical marks are significant in search string values: a
     *            search for &#x60;isaac.brock&#x60; finds &#x60;Isaac.Brock&#x60;, but doesn&#39;t find a property
     *            whose value is &#x60;isáàc.bröck&#x60;. This operation requires [URL
     *            encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example,
     *            &#x60;search&#x3D;profile.department eq \&quot;Engineering\&quot;&#x60; is encoded as
     *            &#x60;search&#x3D;profile.department%20eq%20%22Engineering%22&#x60;. &gt; **Note:** If you use the
     *            special character &#x60;\&quot;&#x60; within a quoted string, it must also be escaped &#x60;\\&#x60;
     *            and encoded. For example, &#x60;search&#x3D;profile.lastName eq \&quot;bob\&quot;smith\&quot;&#x60; is
     *            encoded as &#x60;search&#x3D;profile.lastName%20eq%20%22bob%5C%22smith%22&#x60;. This operation
     *            searches many properties: * Any user profile property, including custom-defined properties * The
     *            top-level properties &#x60;id&#x60;, &#x60;status&#x60;, &#x60;created&#x60;, &#x60;activated&#x60;,
     *            &#x60;statusChanged&#x60;, and &#x60;lastUpdated&#x60; * The [User
     *            Type](https://developer.okta.com/docs/reference/api/user-types/) accessed as &#x60;type.id&#x60; You
     *            can also use &#x60;sortBy&#x60; and &#x60;sortOrder&#x60; parameters. The &#x60;ne&#x60; (not equal)
     *            operator isn&#39;t supported, but you can obtain the same result by using &#x60;lt ... or ...
     *            gt&#x60;. For example, to see all users except those that have a status of &#x60;STAGED&#x60;, use
     *            &#x60;(status lt \&quot;STAGED\&quot; or status gt \&quot;STAGED\&quot;)&#x60;. You can search
     *            properties that are arrays. If any element matches the search term, the entire array (object) is
     *            returned. Okta follows the [SCIM Protocol
     *            Specification](https://tools.ietf.org/html/rfc7644#section-3.4.2.2) for searching arrays. You can
     *            search multiple arrays, multiple values in an array, as well as using the standard logical and
     *            filtering operators. See [Filter](https://developer.okta.com/docs/reference/core-okta-api/#filter).
     *            (optional)
     * @param sortBy
     *            Specifies field to sort by (for search queries only). This can be any single property, for example
     *            &#x60;sortBy&#x3D;profile.lastName&#x60;. Users with the same value for the &#x60;sortBy&#x60;
     *            property will be ordered by &#x60;id&#x60;. (optional)
     * @param sortOrder
     *            Specifies sort order asc or desc (for search queries only). Sorting is done in ASCII sort order (that
     *            is, by ASCII character value), but isn&#39;t case sensitive. &#x60;sortOrder&#x60; is ignored if
     *            &#x60;sortBy&#x60; is not present. (optional)
     *
     * @return List&lt;User&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<User> listUsers(String contentType, String q, String after, Integer limit, String filter, String search,
            String sortBy, String sortOrder) throws ApiException {
        return this.listUsers(contentType, q, after, limit, filter, search, sortBy, sortOrder, Collections.emptyMap());
    }

    /**
     * List all Users Lists Users in your org, with pagination in most cases. A subset of Users can be returned that
     * match a supported filter expression or search criteria.
     *
     * @param contentType
     *            Specifies the media type of the resource. Optional &#x60;okta-response&#x60; value can be included for
     *            performance optimization. Complex DelAuth configurations may degrade performance when fetching
     *            specific parts of the response, and passing this parameter can omit these parts, bypassing the
     *            bottleneck. Enum values for &#x60;okta-response&#x60;: * &#x60;omitCredentials&#x60;: Omits the
     *            credentials subobject from the response. * &#x60;omitCredentialsLinks&#x60;: Omits the following HAL
     *            links from the response: Change Password, Change Recovery Question, Forgot Password, Reset Password,
     *            Reset Factors, Unlock. * &#x60;omitTransitioningToStatus&#x60;: Omits the
     *            &#x60;transitioningToStatus&#x60; field from the response. (optional)
     * @param q
     *            Finds users who match the specified query. This doesn&#39;t support pagination. This might not deliver
     *            optimal performance for large orgs, and is deprecated for such use cases. To ensure optimal
     *            performance, use a [&#x60;search&#x60;
     *            parameter](/openapi/okta-management/management/tag/User/#tag/User/operation/listUsers!in&#x3D;query&amp;path&#x3D;search&amp;t&#x3D;request)
     *            instead. Use the &#x60;q&#x60; parameter for a simple lookup of users by name, for example when
     *            creating a people picker. The value of &#x60;q&#x60; is matched against &#x60;firstName&#x60;,
     *            &#x60;lastName&#x60;, or &#x60;email&#x60;. This performs a &#x60;startsWith&#x60; match, but this is
     *            an implementation detail and can change without notice. You don&#39;t need to specify
     *            &#x60;firstName&#x60;, &#x60;lastName&#x60;, or &#x60;email&#x60;. (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of results returned. Defaults to 10 if &#x60;q&#x60; is provided. (optional,
     *            default to 200)
     * @param filter
     *            Filters users with a supported expression for a subset of properties. This requires [URL
     *            encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example,
     *            &#x60;filter&#x3D;lastUpdated gt \&quot;2013-06-01T00:00:00.000Z\&quot;&#x60; is encoded as
     *            &#x60;filter&#x3D;lastUpdated%20gt%20%222013-06-01T00:00:00.000Z%22&#x60;. Filtering is case-sensitive
     *            for attribute names and query values, while attribute operators are case-insensitive. Filtering
     *            supports the following limited number of properties: &#x60;status&#x60;, &#x60;lastUpdated&#x60;,
     *            &#x60;id&#x60;, &#x60;profile.login&#x60;, &#x60;profile.email&#x60;, &#x60;profile.firstName&#x60;,
     *            and &#x60;profile.lastName&#x60;. Additionally, filtering supports only the equal &#x60;eq&#x60;
     *            operator from the standard Okta API filtering semantics, except in the case of the
     *            &#x60;lastUpdated&#x60; property. This property can also use the inequality operators (&#x60;gt&#x60;,
     *            &#x60;ge&#x60;, &#x60;lt&#x60;, and &#x60;le&#x60;). For logical operators, only the logical operators
     *            &#x60;and&#x60; and &#x60;or&#x60; are supported. The &#x60;not&#x60; operator isn&#39;t supported.
     *            (optional)
     * @param search
     *            Searches for users with a supported filtering expression for most properties. Okta recommends using
     *            this parameter for search for best performance. This operation supports
     *            [pagination](https://developer.okta.com/docs/api/#pagination). Use an ID lookup for records that you
     *            update to ensure your results contain the latest data. Property names in the search parameter are case
     *            sensitive, whereas operators (&#x60;eq&#x60;, &#x60;sw&#x60;, and so on) and string values are case
     *            insensitive. Unlike with user logins, diacritical marks are significant in search string values: a
     *            search for &#x60;isaac.brock&#x60; finds &#x60;Isaac.Brock&#x60;, but doesn&#39;t find a property
     *            whose value is &#x60;isáàc.bröck&#x60;. This operation requires [URL
     *            encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example,
     *            &#x60;search&#x3D;profile.department eq \&quot;Engineering\&quot;&#x60; is encoded as
     *            &#x60;search&#x3D;profile.department%20eq%20%22Engineering%22&#x60;. &gt; **Note:** If you use the
     *            special character &#x60;\&quot;&#x60; within a quoted string, it must also be escaped &#x60;\\&#x60;
     *            and encoded. For example, &#x60;search&#x3D;profile.lastName eq \&quot;bob\&quot;smith\&quot;&#x60; is
     *            encoded as &#x60;search&#x3D;profile.lastName%20eq%20%22bob%5C%22smith%22&#x60;. This operation
     *            searches many properties: * Any user profile property, including custom-defined properties * The
     *            top-level properties &#x60;id&#x60;, &#x60;status&#x60;, &#x60;created&#x60;, &#x60;activated&#x60;,
     *            &#x60;statusChanged&#x60;, and &#x60;lastUpdated&#x60; * The [User
     *            Type](https://developer.okta.com/docs/reference/api/user-types/) accessed as &#x60;type.id&#x60; You
     *            can also use &#x60;sortBy&#x60; and &#x60;sortOrder&#x60; parameters. The &#x60;ne&#x60; (not equal)
     *            operator isn&#39;t supported, but you can obtain the same result by using &#x60;lt ... or ...
     *            gt&#x60;. For example, to see all users except those that have a status of &#x60;STAGED&#x60;, use
     *            &#x60;(status lt \&quot;STAGED\&quot; or status gt \&quot;STAGED\&quot;)&#x60;. You can search
     *            properties that are arrays. If any element matches the search term, the entire array (object) is
     *            returned. Okta follows the [SCIM Protocol
     *            Specification](https://tools.ietf.org/html/rfc7644#section-3.4.2.2) for searching arrays. You can
     *            search multiple arrays, multiple values in an array, as well as using the standard logical and
     *            filtering operators. See [Filter](https://developer.okta.com/docs/reference/core-okta-api/#filter).
     *            (optional)
     * @param sortBy
     *            Specifies field to sort by (for search queries only). This can be any single property, for example
     *            &#x60;sortBy&#x3D;profile.lastName&#x60;. Users with the same value for the &#x60;sortBy&#x60;
     *            property will be ordered by &#x60;id&#x60;. (optional)
     * @param sortOrder
     *            Specifies sort order asc or desc (for search queries only). Sorting is done in ASCII sort order (that
     *            is, by ASCII character value), but isn&#39;t case sensitive. &#x60;sortOrder&#x60; is ignored if
     *            &#x60;sortBy&#x60; is not present. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;User&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<User> listUsers(String contentType, String q, String after, Integer limit, String filter, String search,
            String sortBy, String sortOrder, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/users";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
        if (contentType != null)
            localVarHeaderParams.put("Content-Type", apiClient.parameterToString(contentType));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<User>> localVarReturnType = new TypeReference<List<User>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a User Replaces a User&#39;s profile, credentials, or both using strict-update semantics. All profile
     * properties must be specified when updating a User&#39;s profile with a &#x60;PUT&#x60; method. Any property not
     * specified in the request is deleted. &gt; **Important:** Don&#39;t use a &#x60;PUT&#x60; method for partial
     * updates.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param user
     *            (required)
     * @param strict
     *            If &#x60;true&#x60;, validates against minimum age and history password policy (optional)
     *
     * @return User
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public User replaceUser(String id, UpdateUserRequest user, Boolean strict) throws ApiException {
        return this.replaceUser(id, user, strict, Collections.emptyMap());
    }

    /**
     * Replace a User Replaces a User&#39;s profile, credentials, or both using strict-update semantics. All profile
     * properties must be specified when updating a User&#39;s profile with a &#x60;PUT&#x60; method. Any property not
     * specified in the request is deleted. &gt; **Important:** Don&#39;t use a &#x60;PUT&#x60; method for partial
     * updates.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param user
     *            (required)
     * @param strict
     *            If &#x60;true&#x60;, validates against minimum age and history password policy (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return User
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public User replaceUser(String id, UpdateUserRequest user, Boolean strict, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = user;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling replaceUser");
        }

        // verify the required parameter 'user' is set
        if (user == null) {
            throw new ApiException(400, "Missing the required parameter 'user' when calling replaceUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("strict", strict));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<User> localVarReturnType = new TypeReference<User>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a User Updates a user&#39;s profile or credentials with partial update semantics. &gt; **Important:** Use
     * the &#x60;POST&#x60; method for partial updates. Unspecified properties are set to null with &#x60;PUT&#x60;.
     * &#x60;profile&#x60; and &#x60;credentials&#x60; can be updated independently or together with a single request.
     * &gt; **Note**: Currently, the User Type of a User can only be changed via a full replacement PUT operation. If
     * the request parameters of a partial update include the type element from the User object, the value must match
     * the existing type of the User. Only admins are permitted to change the User type of a User; end users are not
     * allowed to change their own User type. &gt; **Note**: To update a current user&#39;s profile with partial
     * semantics, the &#x60;/api/v1/users/me&#x60; endpoint can be invoked. &gt; &gt; A User can only update profile
     * properties for which the User has write access. Within the profile, if the User tries to update the primary or
     * the secondary email IDs, verification emails are sent to those email IDs, and the fields are updated only upon
     * verification. If you are using this endpoint to set a password, it sets a password without validating existing
     * user credentials. This is an administrative operation. For operations that validate credentials, refer to the
     * &#x60;Reset Password&#x60;, &#x60;Forgot Password&#x60;, and &#x60;Change Password&#x60; endpoints.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param user
     *            (required)
     * @param strict
     *            If true, validates against minimum age and history password policy (optional)
     *
     * @return User
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public User updateUser(String id, UpdateUserRequest user, Boolean strict) throws ApiException {
        return this.updateUser(id, user, strict, Collections.emptyMap());
    }

    /**
     * Update a User Updates a user&#39;s profile or credentials with partial update semantics. &gt; **Important:** Use
     * the &#x60;POST&#x60; method for partial updates. Unspecified properties are set to null with &#x60;PUT&#x60;.
     * &#x60;profile&#x60; and &#x60;credentials&#x60; can be updated independently or together with a single request.
     * &gt; **Note**: Currently, the User Type of a User can only be changed via a full replacement PUT operation. If
     * the request parameters of a partial update include the type element from the User object, the value must match
     * the existing type of the User. Only admins are permitted to change the User type of a User; end users are not
     * allowed to change their own User type. &gt; **Note**: To update a current user&#39;s profile with partial
     * semantics, the &#x60;/api/v1/users/me&#x60; endpoint can be invoked. &gt; &gt; A User can only update profile
     * properties for which the User has write access. Within the profile, if the User tries to update the primary or
     * the secondary email IDs, verification emails are sent to those email IDs, and the fields are updated only upon
     * verification. If you are using this endpoint to set a password, it sets a password without validating existing
     * user credentials. This is an administrative operation. For operations that validate credentials, refer to the
     * &#x60;Reset Password&#x60;, &#x60;Forgot Password&#x60;, and &#x60;Change Password&#x60; endpoints.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param user
     *            (required)
     * @param strict
     *            If true, validates against minimum age and history password policy (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return User
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public User updateUser(String id, UpdateUserRequest user, Boolean strict, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = user;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateUser");
        }

        // verify the required parameter 'user' is set
        if (user == null) {
            throw new ApiException(400, "Missing the required parameter 'user' when calling updateUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("strict", strict));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<User> localVarReturnType = new TypeReference<User>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
