/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.KeepCurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UserSessionsApi {

    private ApiClient apiClient;

    public UserSessionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserSessionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * End a current User session Ends Okta sessions for the currently signed in User. By default, the current session
     * remains active. Use this method in a browser-based app. &gt; **Note:** This operation requires a session cookie
     * for the User. The API token isn&#39;t allowed for this operation.
     *
     * @param keepCurrent
     *            (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void endUserSessions(KeepCurrent keepCurrent) throws ApiException {
        this.endUserSessions(keepCurrent, Collections.emptyMap());
    }

    /**
     * End a current User session Ends Okta sessions for the currently signed in User. By default, the current session
     * remains active. Use this method in a browser-based app. &gt; **Note:** This operation requires a session cookie
     * for the User. The API token isn&#39;t allowed for this operation.
     *
     * @param keepCurrent
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void endUserSessions(KeepCurrent keepCurrent, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = keepCurrent;

        // create path and map variables
        String localVarPath = "/api/v1/users/me/lifecycle/delete_sessions";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Revoke all User sessions Revokes all active Identity Provider sessions of the User. This forces the user to
     * authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued
     * to the User. &gt; **Note:** This operation doesn&#39;t clear the sessions created for web or native apps.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param oauthTokens
     *            Revoke issued OpenID Connect and OAuth refresh and access tokens (optional, default to false)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeUserSessions(String userId, Boolean oauthTokens) throws ApiException {
        this.revokeUserSessions(userId, oauthTokens, Collections.emptyMap());
    }

    /**
     * Revoke all User sessions Revokes all active Identity Provider sessions of the User. This forces the user to
     * authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued
     * to the User. &gt; **Note:** This operation doesn&#39;t clear the sessions created for web or native apps.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param oauthTokens
     *            Revoke issued OpenID Connect and OAuth refresh and access tokens (optional, default to false)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeUserSessions(String userId, Boolean oauthTokens, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling revokeUserSessions");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/sessions".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("oauthTokens", oauthTokens));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
