package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * &lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; The AAGUID Group object supports the Early Access
 * (Self-Service) Allow List for FIDO2 (WebAuthn) Authenticators feature. Enable the feature for your org from the
 * **Settings** &gt; **Features** page in the Admin Console. This feature has several limitations when enrolling a
 * security key: - Enrollment is currently unsupported on Firefox. - Enrollment is currently unsupported on Chrome if
 * User Verification is set to DISCOURAGED and a PIN is set on the security key. - If prompted during enrollment, users
 * must allow Okta to see the make and model of the security key.
 */
@ApiModel(description = "<x-lifecycle class=\"ea\"></x-lifecycle> The AAGUID Group object supports the Early Access (Self-Service) Allow List for FIDO2 (WebAuthn) Authenticators feature. Enable the feature for your org from the **Settings** > **Features** page in the Admin Console.  This feature has several limitations when enrolling a security key:   - Enrollment is currently unsupported on Firefox.   - Enrollment is currently unsupported on Chrome if User Verification is set to DISCOURAGED and a PIN is set on the security key.   - If prompted during enrollment, users must allow Okta to see the make and model of the security key. ")
@JsonPropertyOrder({ AAGUIDGroupObject.JSON_PROPERTY_AAGUIDS, AAGUIDGroupObject.JSON_PROPERTY_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AAGUIDGroupObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AAGUIDS = "aaguids";
    private List<String> aaguids = null;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public AAGUIDGroupObject() {
    }

    public AAGUIDGroupObject aaguids(List<String> aaguids) {

        this.aaguids = aaguids;
        return this;
    }

    public AAGUIDGroupObject addaaguidsItem(String aaguidsItem) {
        if (this.aaguids == null) {
            this.aaguids = new ArrayList<>();
        }
        this.aaguids.add(aaguidsItem);
        return this;
    }

    /**
     * A list of YubiKey hardware FIDO2 Authenticator Attestation Global Unique Identifiers (AAGUIDs). The available
     * [AAGUIDs](https://support.yubico.com/hc/en-us/articles/360016648959-YubiKey-Hardware-FIDO2-AAGUIDs) (opens new
     * window) are provided by the FIDO Alliance Metadata Service.
     *
     * @return aaguids
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A list of YubiKey hardware FIDO2 Authenticator Attestation Global Unique Identifiers (AAGUIDs). The available [AAGUIDs](https://support.yubico.com/hc/en-us/articles/360016648959-YubiKey-Hardware-FIDO2-AAGUIDs) (opens new window) are provided by the FIDO Alliance Metadata Service.")
    @JsonProperty(JSON_PROPERTY_AAGUIDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getAaguids() {
        return aaguids;
    }

    @JsonProperty(JSON_PROPERTY_AAGUIDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAaguids(List<String> aaguids) {
        this.aaguids = aaguids;
    }

    public AAGUIDGroupObject name(String name) {

        this.name = name;
        return this;
    }

    /**
     * A name to identify the group of YubiKey hardware FIDO2 AAGUIDs
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A name to identify the group of YubiKey hardware FIDO2 AAGUIDs")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AAGUIDGroupObject aaGUIDGroupObject = (AAGUIDGroupObject) o;
        return Objects.equals(this.aaguids, aaGUIDGroupObject.aaguids)
                && Objects.equals(this.name, aaGUIDGroupObject.name);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(aaguids, name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AAGUIDGroupObject {\n");
        sb.append("    aaguids: ").append(toIndentedString(aaguids)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
