package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthorizationServerJsonWebKey
 */
@JsonPropertyOrder({ AuthorizationServerJsonWebKey.JSON_PROPERTY_ALG, AuthorizationServerJsonWebKey.JSON_PROPERTY_E,
        AuthorizationServerJsonWebKey.JSON_PROPERTY_KID, AuthorizationServerJsonWebKey.JSON_PROPERTY_KTY,
        AuthorizationServerJsonWebKey.JSON_PROPERTY_N, AuthorizationServerJsonWebKey.JSON_PROPERTY_STATUS,
        AuthorizationServerJsonWebKey.JSON_PROPERTY_USE, AuthorizationServerJsonWebKey.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AuthorizationServerJsonWebKey implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;

    public static final String JSON_PROPERTY_E = "e";
    private String e;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;

    public static final String JSON_PROPERTY_N = "n";
    private String n;

    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public static final String JSON_PROPERTY_USE = "use";
    private String use;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public AuthorizationServerJsonWebKey() {
    }

    /*
     * @JsonCreator public AuthorizationServerJsonWebKey(
     *
     * @JsonProperty(JSON_PROPERTY_E) String e,
     *
     * @JsonProperty(JSON_PROPERTY_KID) String kid,
     *
     * @JsonProperty(JSON_PROPERTY_KTY) String kty,
     *
     * @JsonProperty(JSON_PROPERTY_USE) String use ) { this(); this.e = e; this.kid = kid; this.kty = kty; this.use =
     * use; }
     */

    public AuthorizationServerJsonWebKey alg(String alg) {

        this.alg = alg;
        return this;
    }

    /**
     * The algorithm used with the Key. Valid value: &#x60;RS256&#x60;
     *
     * @return alg
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The algorithm used with the Key. Valid value: `RS256`")
    @JsonProperty(JSON_PROPERTY_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAlg() {
        return alg;
    }

    @JsonProperty(JSON_PROPERTY_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    /**
     * RSA key value (public exponent) for Key binding
     *
     * @return e
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "RSA key value (public exponent) for Key binding")
    @JsonProperty(JSON_PROPERTY_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getE() {
        return e;
    }

    /**
     * Unique identifier for the key
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for the key")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    /**
     * Cryptographic algorithm family for the certificate&#39;s keypair. Valid value: &#x60;RSA&#x60;
     *
     * @return kty
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Cryptographic algorithm family for the certificate's keypair. Valid value: `RSA`")
    @JsonProperty(JSON_PROPERTY_KTY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKty() {
        return kty;
    }

    public AuthorizationServerJsonWebKey n(String n) {

        this.n = n;
        return this;
    }

    /**
     * RSA modulus value that is used by both the public and private keys and provides a link between them
     *
     * @return n
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "RSA modulus value that is used by both the public and private keys and provides a link between them")
    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getN() {
        return n;
    }

    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public AuthorizationServerJsonWebKey status(String status) {

        this.status = status;
        return this;
    }

    /**
     * An &#x60;ACTIVE&#x60; Key is used to sign tokens issued by the authorization server. Supported values:
     * &#x60;ACTIVE&#x60;, &#x60;NEXT&#x60;, or &#x60;EXPIRED&#x60;&lt;br&gt; A &#x60;NEXT&#x60; Key is the next Key
     * that the authorization server uses to sign tokens when Keys are rotated. The &#x60;NEXT&#x60; Key might not be
     * listed if it hasn&#39;t been generated. An &#x60;EXPIRED&#x60; Key is the previous Key that the authorization
     * server used to sign tokens. The &#x60;EXPIRED&#x60; Key might not be listed if no Key has expired or the expired
     * Key was deleted.
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An `ACTIVE` Key is used to sign tokens issued by the authorization server. Supported values: `ACTIVE`, `NEXT`, or `EXPIRED`<br> A `NEXT` Key is the next Key that the authorization server uses to sign tokens when Keys are rotated. The `NEXT` Key might not be listed if it hasn't been generated. An `EXPIRED` Key is the previous Key that the authorization server used to sign tokens. The `EXPIRED` Key might not be listed if no Key has expired or the expired Key was deleted.")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * Acceptable use of the key. Valid value: &#x60;sig&#x60;
     *
     * @return use
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Acceptable use of the key. Valid value: `sig`")
    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUse() {
        return use;
    }

    public AuthorizationServerJsonWebKey links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthorizationServerJsonWebKey authorizationServerJsonWebKey = (AuthorizationServerJsonWebKey) o;
        return Objects.equals(this.alg, authorizationServerJsonWebKey.alg)
                && Objects.equals(this.e, authorizationServerJsonWebKey.e)
                && Objects.equals(this.kid, authorizationServerJsonWebKey.kid)
                && Objects.equals(this.kty, authorizationServerJsonWebKey.kty)
                && Objects.equals(this.n, authorizationServerJsonWebKey.n)
                && Objects.equals(this.status, authorizationServerJsonWebKey.status)
                && Objects.equals(this.use, authorizationServerJsonWebKey.use)
                && Objects.equals(this.links, authorizationServerJsonWebKey.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(alg, e, kid, kty, n, status, use, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationServerJsonWebKey {\n");
        sb.append("    alg: ").append(toIndentedString(alg)).append("\n");
        sb.append("    e: ").append(toIndentedString(e)).append("\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    kty: ").append(toIndentedString(kty)).append("\n");
        sb.append("    n: ").append(toIndentedString(n)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    use: ").append(toIndentedString(use)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
