package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SessionIdentityProvider;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details of the user session
 */
@ApiModel(description = "Details of the user session")
@JsonPropertyOrder({ BaseContextSession.JSON_PROPERTY_ID, BaseContextSession.JSON_PROPERTY_USER_ID,
        BaseContextSession.JSON_PROPERTY_LOGIN, BaseContextSession.JSON_PROPERTY_CREATED_AT,
        BaseContextSession.JSON_PROPERTY_EXPIRES_AT, BaseContextSession.JSON_PROPERTY_STATUS,
        BaseContextSession.JSON_PROPERTY_LAST_PASSWORD_VERIFICATION, BaseContextSession.JSON_PROPERTY_AMR,
        BaseContextSession.JSON_PROPERTY_IDP, BaseContextSession.JSON_PROPERTY_MFA_ACTIVE })
@JsonTypeName("BaseContext_session")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class BaseContextSession implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;

    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;

    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public static final String JSON_PROPERTY_LAST_PASSWORD_VERIFICATION = "lastPasswordVerification";
    private OffsetDateTime lastPasswordVerification;

    public static final String JSON_PROPERTY_AMR = "amr";
    private List<String> amr = null;

    public static final String JSON_PROPERTY_IDP = "idp";
    private SessionIdentityProvider idp;

    public static final String JSON_PROPERTY_MFA_ACTIVE = "mfaActive";
    private Boolean mfaActive;

    public BaseContextSession() {
    }

    public BaseContextSession id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique identifier for the user&#39;s session
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "102LN9Bnuc4S_ewfc9BYwageA", value = "The unique identifier for the user's session")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BaseContextSession userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * The unique identifier for the user
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00uq8tMo3zV0OfJON0g3", value = "The unique identifier for the user")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public BaseContextSession login(String login) {

        this.login = login;
        return this;
    }

    /**
     * The username used to identify the user. This is often the user&#39;s email address.
     *
     * @return login
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "user@example.com", value = "The username used to identify the user. This is often the user's email address.")
    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogin() {
        return login;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogin(String login) {
        this.login = login;
    }

    public BaseContextSession createdAt(OffsetDateTime createdAt) {

        this.createdAt = createdAt;
        return this;
    }

    /**
     * Timestamp of when the session was created
     *
     * @return createdAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2019-03-28T16:45:55Z", value = "Timestamp of when the session was created")
    @JsonProperty(JSON_PROPERTY_CREATED_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty(JSON_PROPERTY_CREATED_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public BaseContextSession expiresAt(OffsetDateTime expiresAt) {

        this.expiresAt = expiresAt;
        return this;
    }

    /**
     * Timestamp of when the session expires
     *
     * @return expiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2019-03-28T21:15:23Z", value = "Timestamp of when the session expires")
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }

    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public BaseContextSession status(String status) {

        this.status = status;
        return this;
    }

    /**
     * Represents the current status of the user&#39;s session
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "ACTIVE", value = "Represents the current status of the user's session")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public BaseContextSession lastPasswordVerification(OffsetDateTime lastPasswordVerification) {

        this.lastPasswordVerification = lastPasswordVerification;
        return this;
    }

    /**
     * Timestamp of when the user was last authenticated
     *
     * @return lastPasswordVerification
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2019-03-28T16:45:55Z", value = "Timestamp of when the user was last authenticated")
    @JsonProperty(JSON_PROPERTY_LAST_PASSWORD_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastPasswordVerification() {
        return lastPasswordVerification;
    }

    @JsonProperty(JSON_PROPERTY_LAST_PASSWORD_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastPasswordVerification(OffsetDateTime lastPasswordVerification) {
        this.lastPasswordVerification = lastPasswordVerification;
    }

    public BaseContextSession amr(List<String> amr) {

        this.amr = amr;
        return this;
    }

    public BaseContextSession addamrItem(String amrItem) {
        if (this.amr == null) {
            this.amr = new ArrayList<>();
        }
        this.amr.add(amrItem);
        return this;
    }

    /**
     * The authentication method reference
     *
     * @return amr
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The authentication method reference")
    @JsonProperty(JSON_PROPERTY_AMR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getAmr() {
        return amr;
    }

    @JsonProperty(JSON_PROPERTY_AMR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAmr(List<String> amr) {
        this.amr = amr;
    }

    public BaseContextSession idp(SessionIdentityProvider idp) {

        this.idp = idp;
        return this;
    }

    /**
     * Get idp
     *
     * @return idp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SessionIdentityProvider getIdp() {
        return idp;
    }

    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdp(SessionIdentityProvider idp) {
        this.idp = idp;
    }

    public BaseContextSession mfaActive(Boolean mfaActive) {

        this.mfaActive = mfaActive;
        return this;
    }

    /**
     * Describes whether multifactor authentication was enabled
     *
     * @return mfaActive
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "false", value = "Describes whether multifactor authentication was enabled")
    @JsonProperty(JSON_PROPERTY_MFA_ACTIVE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getMfaActive() {
        return mfaActive;
    }

    @JsonProperty(JSON_PROPERTY_MFA_ACTIVE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMfaActive(Boolean mfaActive) {
        this.mfaActive = mfaActive;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseContextSession baseContextSession = (BaseContextSession) o;
        return Objects.equals(this.id, baseContextSession.id) && Objects.equals(this.userId, baseContextSession.userId)
                && Objects.equals(this.login, baseContextSession.login)
                && Objects.equals(this.createdAt, baseContextSession.createdAt)
                && Objects.equals(this.expiresAt, baseContextSession.expiresAt)
                && Objects.equals(this.status, baseContextSession.status)
                && Objects.equals(this.lastPasswordVerification, baseContextSession.lastPasswordVerification)
                && Objects.equals(this.amr, baseContextSession.amr) && Objects.equals(this.idp, baseContextSession.idp)
                && Objects.equals(this.mfaActive, baseContextSession.mfaActive);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, userId, login, createdAt, expiresAt, status, lastPasswordVerification, amr, idp,
                mfaActive);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseContextSession {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    lastPasswordVerification: ").append(toIndentedString(lastPasswordVerification)).append("\n");
        sb.append("    amr: ").append(toIndentedString(amr)).append("\n");
        sb.append("    idp: ").append(toIndentedString(idp)).append("\n");
        sb.append("    mfaActive: ").append(toIndentedString(mfaActive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
