package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * BaseContextUserProfile
 */
@JsonPropertyOrder({ BaseContextUserProfile.JSON_PROPERTY_LOGIN, BaseContextUserProfile.JSON_PROPERTY_FIRST_NAME,
        BaseContextUserProfile.JSON_PROPERTY_LAST_NAME, BaseContextUserProfile.JSON_PROPERTY_LOCALE,
        BaseContextUserProfile.JSON_PROPERTY_TIME_ZONE })
@JsonTypeName("BaseContext_user_profile")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class BaseContextUserProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;

    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;

    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;

    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;

    public static final String JSON_PROPERTY_TIME_ZONE = "timeZone";
    private String timeZone;

    public BaseContextUserProfile() {
    }

    public BaseContextUserProfile login(String login) {

        this.login = login;
        return this;
    }

    /**
     * The username used to identify the user. This is often the user&#39;s email address.
     *
     * @return login
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "user@example.com", value = "The username used to identify the user. This is often the user's email address.")
    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogin() {
        return login;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogin(String login) {
        this.login = login;
    }

    public BaseContextUserProfile firstName(String firstName) {

        this.firstName = firstName;
        return this;
    }

    /**
     * The first name of the user
     *
     * @return firstName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "John", value = "The first name of the user")
    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFirstName() {
        return firstName;
    }

    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public BaseContextUserProfile lastName(String lastName) {

        this.lastName = lastName;
        return this;
    }

    /**
     * The last name of the user
     *
     * @return lastName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Smith", value = "The last name of the user")
    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastName() {
        return lastName;
    }

    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public BaseContextUserProfile locale(String locale) {

        this.locale = locale;
        return this;
    }

    /**
     * The user&#39;s default location for purposes of localizing items such as currency, date time format, numerical
     * representations, and so on. A locale value is a concatenation of the [ISO
     * 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes) two-letter language code, an underscore, and
     * the [ISO 3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) two-letter country code. For example,
     * &#x60;en_US&#x60; specifies the language English and country US. This value is &#x60;en_US&#x60; by default.
     *
     * @return locale
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "en_US", value = "The user's default location for purposes of localizing items such as currency, date time format, numerical representations, and so on. A locale value is a concatenation of the [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes) two-letter language code, an underscore, and the [ISO 3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) two-letter country code. For example, `en_US` specifies the language English and country US. This value is `en_US` by default.")
    @JsonProperty(JSON_PROPERTY_LOCALE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLocale() {
        return locale;
    }

    @JsonProperty(JSON_PROPERTY_LOCALE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public BaseContextUserProfile timeZone(String timeZone) {

        this.timeZone = timeZone;
        return this;
    }

    /**
     * The user&#39;s timezone
     *
     * @return timeZone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "America/Los_Angeles", value = "The user's timezone")
    @JsonProperty(JSON_PROPERTY_TIME_ZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTimeZone() {
        return timeZone;
    }

    @JsonProperty(JSON_PROPERTY_TIME_ZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseContextUserProfile baseContextUserProfile = (BaseContextUserProfile) o;
        return Objects.equals(this.login, baseContextUserProfile.login)
                && Objects.equals(this.firstName, baseContextUserProfile.firstName)
                && Objects.equals(this.lastName, baseContextUserProfile.lastName)
                && Objects.equals(this.locale, baseContextUserProfile.locale)
                && Objects.equals(this.timeZone, baseContextUserProfile.timeZone);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(login, firstName, lastName, locale, timeZone);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseContextUserProfile {\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
        sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
        sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
        sb.append("    timeZone: ").append(toIndentedString(timeZone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
