package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.RolePermissionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CreateIamRoleRequest
 */
@JsonPropertyOrder({ CreateIamRoleRequest.JSON_PROPERTY_DESCRIPTION, CreateIamRoleRequest.JSON_PROPERTY_LABEL,
        CreateIamRoleRequest.JSON_PROPERTY_PERMISSIONS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class CreateIamRoleRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private List<RolePermissionType> permissions = new ArrayList<>();

    public CreateIamRoleRequest() {
    }

    public CreateIamRoleRequest description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the role
     *
     * @return description
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Description of the role")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateIamRoleRequest label(String label) {

        this.label = label;
        return this;
    }

    /**
     * Unique label for the role
     *
     * @return label
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Unique label for the role")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public CreateIamRoleRequest permissions(List<RolePermissionType> permissions) {

        this.permissions = permissions;
        return this;
    }

    public CreateIamRoleRequest addpermissionsItem(RolePermissionType permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    /**
     * Array of permissions that the Role grants. See [Permissions](/openapi/okta-management/guides/roles/#permissions).
     *
     * @return permissions
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Array of permissions that the Role grants. See [Permissions](/openapi/okta-management/guides/roles/#permissions).")
    @JsonProperty(JSON_PROPERTY_PERMISSIONS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<RolePermissionType> getPermissions() {
        return permissions;
    }

    @JsonProperty(JSON_PROPERTY_PERMISSIONS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPermissions(List<RolePermissionType> permissions) {
        this.permissions = permissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateIamRoleRequest createIamRoleRequest = (CreateIamRoleRequest) o;
        return Objects.equals(this.description, createIamRoleRequest.description)
                && Objects.equals(this.label, createIamRoleRequest.label)
                && Objects.equals(this.permissions, createIamRoleRequest.permissions);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, label, permissions);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateIamRoleRequest {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
