package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DefaultApp
 */
@JsonPropertyOrder({ DefaultApp.JSON_PROPERTY_APP_INSTANCE_ID, DefaultApp.JSON_PROPERTY_APP_LINK_NAME,
        DefaultApp.JSON_PROPERTY_CLASSIC_APPLICATION_URI })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class DefaultApp implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APP_INSTANCE_ID = "appInstanceId";
    private String appInstanceId;

    public static final String JSON_PROPERTY_APP_LINK_NAME = "appLinkName";
    private String appLinkName;

    public static final String JSON_PROPERTY_CLASSIC_APPLICATION_URI = "classicApplicationUri";
    private String classicApplicationUri;

    public DefaultApp() {
    }

    public DefaultApp appInstanceId(String appInstanceId) {

        this.appInstanceId = appInstanceId;
        return this;
    }

    /**
     * ID for the App instance
     *
     * @return appInstanceId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID for the App instance")
    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppInstanceId() {
        return appInstanceId;
    }

    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppInstanceId(String appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    public DefaultApp appLinkName(String appLinkName) {

        this.appLinkName = appLinkName;
        return this;
    }

    /**
     * Name for the app instance
     *
     * @return appLinkName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name for the app instance")
    @JsonProperty(JSON_PROPERTY_APP_LINK_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppLinkName() {
        return appLinkName;
    }

    @JsonProperty(JSON_PROPERTY_APP_LINK_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppLinkName(String appLinkName) {
        this.appLinkName = appLinkName;
    }

    public DefaultApp classicApplicationUri(String classicApplicationUri) {

        this.classicApplicationUri = classicApplicationUri;
        return this;
    }

    /**
     * Application URI for classic Orgs
     *
     * @return classicApplicationUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Application URI for classic Orgs")
    @JsonProperty(JSON_PROPERTY_CLASSIC_APPLICATION_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClassicApplicationUri() {
        return classicApplicationUri;
    }

    @JsonProperty(JSON_PROPERTY_CLASSIC_APPLICATION_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClassicApplicationUri(String classicApplicationUri) {
        this.classicApplicationUri = classicApplicationUri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DefaultApp defaultApp = (DefaultApp) o;
        return Objects.equals(this.appInstanceId, defaultApp.appInstanceId)
                && Objects.equals(this.appLinkName, defaultApp.appLinkName)
                && Objects.equals(this.classicApplicationUri, defaultApp.classicApplicationUri);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(appInstanceId, appLinkName, classicApplicationUri);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DefaultApp {\n");
        sb.append("    appInstanceId: ").append(toIndentedString(appInstanceId)).append("\n");
        sb.append("    appLinkName: ").append(toIndentedString(appLinkName)).append("\n");
        sb.append("    classicApplicationUri: ").append(toIndentedString(classicApplicationUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
