package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DeviceAssurance;
import com.okta.sdk.resource.model.DeviceAssuranceAndroidPlatformAllOfScreenLockType;
import com.okta.sdk.resource.model.DeviceAssuranceMacOSPlatformAllOfDiskEncryptionType;
import com.okta.sdk.resource.model.DeviceAssuranceMacOSPlatformAllOfThirdPartySignalProviders;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.OSVersion;
import com.okta.sdk.resource.model.Platform;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DeviceAssuranceMacOSPlatform
 */
@JsonPropertyOrder({ DeviceAssuranceMacOSPlatform.JSON_PROPERTY_DISK_ENCRYPTION_TYPE,
        DeviceAssuranceMacOSPlatform.JSON_PROPERTY_OS_VERSION,
        DeviceAssuranceMacOSPlatform.JSON_PROPERTY_SCREEN_LOCK_TYPE,
        DeviceAssuranceMacOSPlatform.JSON_PROPERTY_SECURE_HARDWARE_PRESENT,
        DeviceAssuranceMacOSPlatform.JSON_PROPERTY_THIRD_PARTY_SIGNAL_PROVIDERS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "platform", visible = true, defaultImpl = DeviceAssuranceMacOSPlatform.class)

public class DeviceAssuranceMacOSPlatform extends DeviceAssurance implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DISK_ENCRYPTION_TYPE = "diskEncryptionType";
    private DeviceAssuranceMacOSPlatformAllOfDiskEncryptionType diskEncryptionType;

    public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
    private OSVersion osVersion;

    public static final String JSON_PROPERTY_SCREEN_LOCK_TYPE = "screenLockType";
    private DeviceAssuranceAndroidPlatformAllOfScreenLockType screenLockType;

    public static final String JSON_PROPERTY_SECURE_HARDWARE_PRESENT = "secureHardwarePresent";
    private Boolean secureHardwarePresent;

    public static final String JSON_PROPERTY_THIRD_PARTY_SIGNAL_PROVIDERS = "thirdPartySignalProviders";
    private DeviceAssuranceMacOSPlatformAllOfThirdPartySignalProviders thirdPartySignalProviders;

    public DeviceAssuranceMacOSPlatform() {
    }

    /*
     * @JsonCreator public DeviceAssuranceMacOSPlatform(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_BY) String createdBy,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_DATE) String createdDate,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATE) String lastUpdate,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY) String lastUpdatedBy ) { this(); this.createdBy = createdBy;
     * this.createdDate = createdDate; this.id = id; this.lastUpdate = lastUpdate; this.lastUpdatedBy = lastUpdatedBy; }
     */

    public DeviceAssuranceMacOSPlatform diskEncryptionType(
            DeviceAssuranceMacOSPlatformAllOfDiskEncryptionType diskEncryptionType) {

        this.diskEncryptionType = diskEncryptionType;
        return this;
    }

    /**
     * Get diskEncryptionType
     *
     * @return diskEncryptionType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceAssuranceMacOSPlatformAllOfDiskEncryptionType getDiskEncryptionType() {
        return diskEncryptionType;
    }

    @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDiskEncryptionType(DeviceAssuranceMacOSPlatformAllOfDiskEncryptionType diskEncryptionType) {
        this.diskEncryptionType = diskEncryptionType;
    }

    public DeviceAssuranceMacOSPlatform osVersion(OSVersion osVersion) {

        this.osVersion = osVersion;
        return this;
    }

    /**
     * Get osVersion
     *
     * @return osVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OSVersion getOsVersion() {
        return osVersion;
    }

    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOsVersion(OSVersion osVersion) {
        this.osVersion = osVersion;
    }

    public DeviceAssuranceMacOSPlatform screenLockType(
            DeviceAssuranceAndroidPlatformAllOfScreenLockType screenLockType) {

        this.screenLockType = screenLockType;
        return this;
    }

    /**
     * Get screenLockType
     *
     * @return screenLockType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceAssuranceAndroidPlatformAllOfScreenLockType getScreenLockType() {
        return screenLockType;
    }

    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockType(DeviceAssuranceAndroidPlatformAllOfScreenLockType screenLockType) {
        this.screenLockType = screenLockType;
    }

    public DeviceAssuranceMacOSPlatform secureHardwarePresent(Boolean secureHardwarePresent) {

        this.secureHardwarePresent = secureHardwarePresent;
        return this;
    }

    /**
     * Get secureHardwarePresent
     *
     * @return secureHardwarePresent
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SECURE_HARDWARE_PRESENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSecureHardwarePresent() {
        return secureHardwarePresent;
    }

    @JsonProperty(JSON_PROPERTY_SECURE_HARDWARE_PRESENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSecureHardwarePresent(Boolean secureHardwarePresent) {
        this.secureHardwarePresent = secureHardwarePresent;
    }

    public DeviceAssuranceMacOSPlatform thirdPartySignalProviders(
            DeviceAssuranceMacOSPlatformAllOfThirdPartySignalProviders thirdPartySignalProviders) {

        this.thirdPartySignalProviders = thirdPartySignalProviders;
        return this;
    }

    /**
     * Get thirdPartySignalProviders
     *
     * @return thirdPartySignalProviders
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_THIRD_PARTY_SIGNAL_PROVIDERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceAssuranceMacOSPlatformAllOfThirdPartySignalProviders getThirdPartySignalProviders() {
        return thirdPartySignalProviders;
    }

    @JsonProperty(JSON_PROPERTY_THIRD_PARTY_SIGNAL_PROVIDERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setThirdPartySignalProviders(
            DeviceAssuranceMacOSPlatformAllOfThirdPartySignalProviders thirdPartySignalProviders) {
        this.thirdPartySignalProviders = thirdPartySignalProviders;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceAssuranceMacOSPlatform deviceAssuranceMacOSPlatform = (DeviceAssuranceMacOSPlatform) o;
        return Objects.equals(this.diskEncryptionType, deviceAssuranceMacOSPlatform.diskEncryptionType)
                && Objects.equals(this.osVersion, deviceAssuranceMacOSPlatform.osVersion)
                && Objects.equals(this.screenLockType, deviceAssuranceMacOSPlatform.screenLockType)
                && Objects.equals(this.secureHardwarePresent, deviceAssuranceMacOSPlatform.secureHardwarePresent)
                && Objects.equals(this.thirdPartySignalProviders,
                        deviceAssuranceMacOSPlatform.thirdPartySignalProviders);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(diskEncryptionType, osVersion, screenLockType, secureHardwarePresent,
                thirdPartySignalProviders, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceAssuranceMacOSPlatform {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    diskEncryptionType: ").append(toIndentedString(diskEncryptionType)).append("\n");
        sb.append("    osVersion: ").append(toIndentedString(osVersion)).append("\n");
        sb.append("    screenLockType: ").append(toIndentedString(screenLockType)).append("\n");
        sb.append("    secureHardwarePresent: ").append(toIndentedString(secureHardwarePresent)).append("\n");
        sb.append("    thirdPartySignalProviders: ").append(toIndentedString(thirdPartySignalProviders)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
