package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObjectAppLink;
import com.okta.sdk.resource.model.HrefObjectGroupLink;
import com.okta.sdk.resource.model.HrefObjectResourceSetLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available using the [JSON
 * Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ EntitlementValueLinks.JSON_PROPERTY_GROUP, EntitlementValueLinks.JSON_PROPERTY_APP,
        EntitlementValueLinks.JSON_PROPERTY_RESOURCE_SET })
@JsonTypeName("EntitlementValue__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class EntitlementValueLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GROUP = "group";
    private HrefObjectGroupLink group;

    public static final String JSON_PROPERTY_APP = "app";
    private HrefObjectAppLink app;

    public static final String JSON_PROPERTY_RESOURCE_SET = "resource-set";
    private HrefObjectResourceSetLink resourceSet;

    public EntitlementValueLinks() {
    }

    public EntitlementValueLinks group(HrefObjectGroupLink group) {

        this.group = group;
        return this;
    }

    /**
     * Get group
     *
     * @return group
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectGroupLink getGroup() {
        return group;
    }

    @JsonProperty(JSON_PROPERTY_GROUP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroup(HrefObjectGroupLink group) {
        this.group = group;
    }

    public EntitlementValueLinks app(HrefObjectAppLink app) {

        this.app = app;
        return this;
    }

    /**
     * Get app
     *
     * @return app
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectAppLink getApp() {
        return app;
    }

    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApp(HrefObjectAppLink app) {
        this.app = app;
    }

    public EntitlementValueLinks resourceSet(HrefObjectResourceSetLink resourceSet) {

        this.resourceSet = resourceSet;
        return this;
    }

    /**
     * Get resourceSet
     *
     * @return resourceSet
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectResourceSetLink getResourceSet() {
        return resourceSet;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResourceSet(HrefObjectResourceSetLink resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EntitlementValueLinks entitlementValueLinks = (EntitlementValueLinks) o;
        return Objects.equals(this.group, entitlementValueLinks.group)
                && Objects.equals(this.app, entitlementValueLinks.app)
                && Objects.equals(this.resourceSet, entitlementValueLinks.resourceSet);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(group, app, resourceSet);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntitlementValueLinks {\n");
        sb.append("    group: ").append(toIndentedString(group)).append("\n");
        sb.append("    app: ").append(toIndentedString(app)).append("\n");
        sb.append("    resourceSet: ").append(toIndentedString(resourceSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
