package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Google app instance properties
 */
@ApiModel(description = "Google app instance properties")
@JsonPropertyOrder({ GoogleApplicationSettingsApplication.JSON_PROPERTY_DOMAIN,
        GoogleApplicationSettingsApplication.JSON_PROPERTY_RP_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class GoogleApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public static final String JSON_PROPERTY_RP_ID = "rpId";
    private String rpId;

    public GoogleApplicationSettingsApplication() {
    }

    public GoogleApplicationSettingsApplication domain(String domain) {

        this.domain = domain;
        return this;
    }

    /**
     * Your Google company domain
     *
     * @return domain
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Your Google company domain")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDomain() {
        return domain;
    }

    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public GoogleApplicationSettingsApplication rpId(String rpId) {

        this.rpId = rpId;
        return this;
    }

    /**
     * RPID
     *
     * @return rpId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "RPID")
    @JsonProperty(JSON_PROPERTY_RP_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRpId() {
        return rpId;
    }

    @JsonProperty(JSON_PROPERTY_RP_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRpId(String rpId) {
        this.rpId = rpId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GoogleApplicationSettingsApplication googleApplicationSettingsApplication = (GoogleApplicationSettingsApplication) o;
        return Objects.equals(this.domain, googleApplicationSettingsApplication.domain)
                && Objects.equals(this.rpId, googleApplicationSettingsApplication.rpId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, rpId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GoogleApplicationSettingsApplication {\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("    rpId: ").append(toIndentedString(rpId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
