package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdentityProviderCredentialsClient
 */
@JsonPropertyOrder({ IdentityProviderCredentialsClient.JSON_PROPERTY_CLIENT_ID,
        IdentityProviderCredentialsClient.JSON_PROPERTY_CLIENT_SECRET,
        IdentityProviderCredentialsClient.JSON_PROPERTY_PKCE_REQUIRED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class IdentityProviderCredentialsClient implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;

    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;

    public static final String JSON_PROPERTY_PKCE_REQUIRED = "pkce_required";
    private Boolean pkceRequired;

    public IdentityProviderCredentialsClient() {
    }

    public IdentityProviderCredentialsClient clientId(String clientId) {

        this.clientId = clientId;
        return this;
    }

    /**
     * Get clientId
     *
     * @return clientId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public IdentityProviderCredentialsClient clientSecret(String clientSecret) {

        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get clientSecret
     *
     * @return clientSecret
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientSecret() {
        return clientSecret;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public IdentityProviderCredentialsClient pkceRequired(Boolean pkceRequired) {

        this.pkceRequired = pkceRequired;
        return this;
    }

    /**
     * Require Proof Key for Code Exchange (PKCE) for additional verification
     *
     * @return pkceRequired
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Require Proof Key for Code Exchange (PKCE) for additional verification")
    @JsonProperty(JSON_PROPERTY_PKCE_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getPkceRequired() {
        return pkceRequired;
    }

    @JsonProperty(JSON_PROPERTY_PKCE_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPkceRequired(Boolean pkceRequired) {
        this.pkceRequired = pkceRequired;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderCredentialsClient identityProviderCredentialsClient = (IdentityProviderCredentialsClient) o;
        return Objects.equals(this.clientId, identityProviderCredentialsClient.clientId)
                && Objects.equals(this.clientSecret, identityProviderCredentialsClient.clientSecret)
                && Objects.equals(this.pkceRequired, identityProviderCredentialsClient.pkceRequired);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, clientSecret, pkceRequired);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderCredentialsClient {\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
        sb.append("    pkceRequired: ").append(toIndentedString(pkceRequired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
