package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityProviderCredentialsTrustRevocation;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdentityProviderCredentialsTrust
 */
@JsonPropertyOrder({ IdentityProviderCredentialsTrust.JSON_PROPERTY_AUDIENCE,
        IdentityProviderCredentialsTrust.JSON_PROPERTY_ISSUER, IdentityProviderCredentialsTrust.JSON_PROPERTY_KID,
        IdentityProviderCredentialsTrust.JSON_PROPERTY_REVOCATION,
        IdentityProviderCredentialsTrust.JSON_PROPERTY_REVOCATION_CACHE_LIFETIME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class IdentityProviderCredentialsTrust implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUDIENCE = "audience";
    private String audience;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_REVOCATION = "revocation";
    private IdentityProviderCredentialsTrustRevocation revocation;

    public static final String JSON_PROPERTY_REVOCATION_CACHE_LIFETIME = "revocationCacheLifetime";
    private Integer revocationCacheLifetime;

    public IdentityProviderCredentialsTrust() {
    }

    public IdentityProviderCredentialsTrust audience(String audience) {

        this.audience = audience;
        return this;
    }

    /**
     * Get audience
     *
     * @return audience
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AUDIENCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAudience() {
        return audience;
    }

    @JsonProperty(JSON_PROPERTY_AUDIENCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAudience(String audience) {
        this.audience = audience;
    }

    public IdentityProviderCredentialsTrust issuer(String issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * Get issuer
     *
     * @return issuer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public IdentityProviderCredentialsTrust kid(String kid) {

        this.kid = kid;
        return this;
    }

    /**
     * Get kid
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public IdentityProviderCredentialsTrust revocation(IdentityProviderCredentialsTrustRevocation revocation) {

        this.revocation = revocation;
        return this;
    }

    /**
     * Get revocation
     *
     * @return revocation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REVOCATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderCredentialsTrustRevocation getRevocation() {
        return revocation;
    }

    @JsonProperty(JSON_PROPERTY_REVOCATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRevocation(IdentityProviderCredentialsTrustRevocation revocation) {
        this.revocation = revocation;
    }

    public IdentityProviderCredentialsTrust revocationCacheLifetime(Integer revocationCacheLifetime) {

        this.revocationCacheLifetime = revocationCacheLifetime;
        return this;
    }

    /**
     * Get revocationCacheLifetime
     *
     * @return revocationCacheLifetime
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REVOCATION_CACHE_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getRevocationCacheLifetime() {
        return revocationCacheLifetime;
    }

    @JsonProperty(JSON_PROPERTY_REVOCATION_CACHE_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRevocationCacheLifetime(Integer revocationCacheLifetime) {
        this.revocationCacheLifetime = revocationCacheLifetime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderCredentialsTrust identityProviderCredentialsTrust = (IdentityProviderCredentialsTrust) o;
        return Objects.equals(this.audience, identityProviderCredentialsTrust.audience)
                && Objects.equals(this.issuer, identityProviderCredentialsTrust.issuer)
                && Objects.equals(this.kid, identityProviderCredentialsTrust.kid)
                && Objects.equals(this.revocation, identityProviderCredentialsTrust.revocation) && Objects
                        .equals(this.revocationCacheLifetime, identityProviderCredentialsTrust.revocationCacheLifetime);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(audience, issuer, kid, revocation, revocationCacheLifetime);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderCredentialsTrust {\n");
        sb.append("    audience: ").append(toIndentedString(audience)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    revocation: ").append(toIndentedString(revocation)).append("\n");
        sb.append("    revocationCacheLifetime: ").append(toIndentedString(revocationCacheLifetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
