package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObject;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdentityProviderLinks
 */
@JsonPropertyOrder({ IdentityProviderLinks.JSON_PROPERTY_SELF, IdentityProviderLinks.JSON_PROPERTY_ACS,
        IdentityProviderLinks.JSON_PROPERTY_AUTHORIZE, IdentityProviderLinks.JSON_PROPERTY_CLIENT_REDIRECT_URI,
        IdentityProviderLinks.JSON_PROPERTY_METADATA, IdentityProviderLinks.JSON_PROPERTY_USERS,
        IdentityProviderLinks.JSON_PROPERTY_DEACTIVATE, IdentityProviderLinks.JSON_PROPERTY_ACTIVATE,
        IdentityProviderLinks.JSON_PROPERTY_KEYS })
@JsonTypeName("IdentityProvider__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class IdentityProviderLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public Map<String, Object> additionalProperties = new java.util.LinkedHashMap<>();

    public Map<String, Object> getAdditionalProperties() {
        return additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_ACS = "acs";
    private HrefObject acs;

    public static final String JSON_PROPERTY_AUTHORIZE = "authorize";
    private HrefObject authorize;

    public static final String JSON_PROPERTY_CLIENT_REDIRECT_URI = "clientRedirectUri";
    private HrefObject clientRedirectUri;

    public static final String JSON_PROPERTY_METADATA = "metadata";
    private HrefObject metadata;

    public static final String JSON_PROPERTY_USERS = "users";
    private HrefObject users;

    public static final String JSON_PROPERTY_DEACTIVATE = "deactivate";
    private HrefObject deactivate;

    public static final String JSON_PROPERTY_ACTIVATE = "activate";
    private HrefObject activate;

    public static final String JSON_PROPERTY_KEYS = "keys";
    private HrefObject keys;

    public IdentityProviderLinks() {
    }

    public IdentityProviderLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public IdentityProviderLinks acs(HrefObject acs) {

        this.acs = acs;
        return this;
    }

    /**
     * SAML 2.0 Assertion Consumer Service URL for the Okta SP
     *
     * @return acs
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "SAML 2.0 Assertion Consumer Service URL for the Okta SP")
    @JsonProperty(JSON_PROPERTY_ACS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getAcs() {
        return acs;
    }

    @JsonProperty(JSON_PROPERTY_ACS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAcs(HrefObject acs) {
        this.acs = acs;
    }

    public IdentityProviderLinks authorize(HrefObject authorize) {

        this.authorize = authorize;
        return this;
    }

    /**
     * OAuth 2.0 authorization endpoint for the IdP OAuth 2.0 Authorization Code flow
     *
     * @return authorize
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "OAuth 2.0 authorization endpoint for the IdP OAuth 2.0 Authorization Code flow")
    @JsonProperty(JSON_PROPERTY_AUTHORIZE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getAuthorize() {
        return authorize;
    }

    @JsonProperty(JSON_PROPERTY_AUTHORIZE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorize(HrefObject authorize) {
        this.authorize = authorize;
    }

    public IdentityProviderLinks clientRedirectUri(HrefObject clientRedirectUri) {

        this.clientRedirectUri = clientRedirectUri;
        return this;
    }

    /**
     * Redirect URI for the OAuth 2.0 Authorization Code flow
     *
     * @return clientRedirectUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Redirect URI for the OAuth 2.0 Authorization Code flow")
    @JsonProperty(JSON_PROPERTY_CLIENT_REDIRECT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getClientRedirectUri() {
        return clientRedirectUri;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_REDIRECT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientRedirectUri(HrefObject clientRedirectUri) {
        this.clientRedirectUri = clientRedirectUri;
    }

    public IdentityProviderLinks metadata(HrefObject metadata) {

        this.metadata = metadata;
        return this;
    }

    /**
     * Federation metadata document for the IdP (for example: SAML 2.0 Metadata)
     *
     * @return metadata
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Federation metadata document for the IdP (for example: SAML 2.0 Metadata)")
    @JsonProperty(JSON_PROPERTY_METADATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getMetadata() {
        return metadata;
    }

    @JsonProperty(JSON_PROPERTY_METADATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(HrefObject metadata) {
        this.metadata = metadata;
    }

    public IdentityProviderLinks users(HrefObject users) {

        this.users = users;
        return this;
    }

    /**
     * IdP users
     *
     * @return users
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "IdP users")
    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getUsers() {
        return users;
    }

    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(HrefObject users) {
        this.users = users;
    }

    public IdentityProviderLinks deactivate(HrefObject deactivate) {

        this.deactivate = deactivate;
        return this;
    }

    /**
     * Deactivate IdP
     *
     * @return deactivate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Deactivate IdP")
    @JsonProperty(JSON_PROPERTY_DEACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getDeactivate() {
        return deactivate;
    }

    @JsonProperty(JSON_PROPERTY_DEACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeactivate(HrefObject deactivate) {
        this.deactivate = deactivate;
    }

    public IdentityProviderLinks activate(HrefObject activate) {

        this.activate = activate;
        return this;
    }

    /**
     * Activate IdP
     *
     * @return activate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Activate IdP")
    @JsonProperty(JSON_PROPERTY_ACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getActivate() {
        return activate;
    }

    @JsonProperty(JSON_PROPERTY_ACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setActivate(HrefObject activate) {
        this.activate = activate;
    }

    public IdentityProviderLinks keys(HrefObject keys) {

        this.keys = keys;
        return this;
    }

    /**
     * IdP keys
     *
     * @return keys
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "IdP keys")
    @JsonProperty(JSON_PROPERTY_KEYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getKeys() {
        return keys;
    }

    @JsonProperty(JSON_PROPERTY_KEYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKeys(HrefObject keys) {
        this.keys = keys;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderLinks identityProviderLinks = (IdentityProviderLinks) o;
        return Objects.equals(this.self, identityProviderLinks.self)
                && Objects.equals(this.acs, identityProviderLinks.acs)
                && Objects.equals(this.authorize, identityProviderLinks.authorize)
                && Objects.equals(this.clientRedirectUri, identityProviderLinks.clientRedirectUri)
                && Objects.equals(this.metadata, identityProviderLinks.metadata)
                && Objects.equals(this.users, identityProviderLinks.users)
                && Objects.equals(this.deactivate, identityProviderLinks.deactivate)
                && Objects.equals(this.activate, identityProviderLinks.activate)
                && Objects.equals(this.keys, identityProviderLinks.keys);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, acs, authorize, clientRedirectUri, metadata, users, deactivate, activate, keys,
                super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderLinks {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    acs: ").append(toIndentedString(acs)).append("\n");
        sb.append("    authorize: ").append(toIndentedString(authorize)).append("\n");
        sb.append("    clientRedirectUri: ").append(toIndentedString(clientRedirectUri)).append("\n");
        sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
        sb.append("    users: ").append(toIndentedString(users)).append("\n");
        sb.append("    deactivate: ").append(toIndentedString(deactivate)).append("\n");
        sb.append("    activate: ").append(toIndentedString(activate)).append("\n");
        sb.append("    keys: ").append(toIndentedString(keys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
