package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ImportScheduleObjectIncrementalImport
 */
@JsonPropertyOrder({ ImportScheduleObjectIncrementalImport.JSON_PROPERTY_EXPRESSION,
        ImportScheduleObjectIncrementalImport.JSON_PROPERTY_TIMEZONE })
@JsonTypeName("ImportScheduleObject_incrementalImport")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ImportScheduleObjectIncrementalImport implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;

    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;

    public ImportScheduleObjectIncrementalImport() {
    }

    public ImportScheduleObjectIncrementalImport expression(String expression) {

        this.expression = expression;
        return this;
    }

    /**
     * The import schedule in UNIX cron format
     *
     * @return expression
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "00 21 * * Mon,Thu,Fri,Sat", required = true, value = "The import schedule in UNIX cron format")
    @JsonProperty(JSON_PROPERTY_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getExpression() {
        return expression;
    }

    @JsonProperty(JSON_PROPERTY_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ImportScheduleObjectIncrementalImport timezone(String timezone) {

        this.timezone = timezone;
        return this;
    }

    /**
     * The import schedule time zone in Internet Assigned Numbers Authority (IANA) time zone name format
     *
     * @return timezone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "America/Los_Angeles", value = "The import schedule time zone in Internet Assigned Numbers Authority (IANA) time zone name format")
    @JsonProperty(JSON_PROPERTY_TIMEZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTimezone() {
        return timezone;
    }

    @JsonProperty(JSON_PROPERTY_TIMEZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportScheduleObjectIncrementalImport importScheduleObjectIncrementalImport = (ImportScheduleObjectIncrementalImport) o;
        return Objects.equals(this.expression, importScheduleObjectIncrementalImport.expression)
                && Objects.equals(this.timezone, importScheduleObjectIncrementalImport.timezone);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expression, timezone);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportScheduleObjectIncrementalImport {\n");
        sb.append("    expression: ").append(toIndentedString(expression)).append("\n");
        sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
