package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.InlineHookRequestObjectUrl;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The API request that triggered the inline hook
 */
@ApiModel(description = "The API request that triggered the inline hook")
@JsonPropertyOrder({ InlineHookRequestObject.JSON_PROPERTY_ID, InlineHookRequestObject.JSON_PROPERTY_IP_ADDRESS,
        InlineHookRequestObject.JSON_PROPERTY_METHOD, InlineHookRequestObject.JSON_PROPERTY_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class InlineHookRequestObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;

    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;

    public static final String JSON_PROPERTY_URL = "url";
    private InlineHookRequestObjectUrl url;

    public InlineHookRequestObject() {
    }

    public InlineHookRequestObject id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique identifier that Okta assigned to the API request
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique identifier that Okta assigned to the API request")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public InlineHookRequestObject ipAddress(String ipAddress) {

        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * The IP address of the client that made the API request
     *
     * @return ipAddress
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The IP address of the client that made the API request")
    @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIpAddress() {
        return ipAddress;
    }

    @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public InlineHookRequestObject method(String method) {

        this.method = method;
        return this;
    }

    /**
     * The HTTP request method of the API request
     *
     * @return method
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The HTTP request method of the API request")
    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMethod() {
        return method;
    }

    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(String method) {
        this.method = method;
    }

    public InlineHookRequestObject url(InlineHookRequestObjectUrl url) {

        this.url = url;
        return this;
    }

    /**
     * Get url
     *
     * @return url
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public InlineHookRequestObjectUrl getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(InlineHookRequestObjectUrl url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InlineHookRequestObject inlineHookRequestObject = (InlineHookRequestObject) o;
        return Objects.equals(this.id, inlineHookRequestObject.id)
                && Objects.equals(this.ipAddress, inlineHookRequestObject.ipAddress)
                && Objects.equals(this.method, inlineHookRequestObject.method)
                && Objects.equals(this.url, inlineHookRequestObject.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, ipAddress, method, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineHookRequestObject {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
        sb.append("    method: ").append(toIndentedString(method)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
