package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinkedObjectDetailsType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * LinkedObjectDetails
 */
@JsonPropertyOrder({ LinkedObjectDetails.JSON_PROPERTY_DESCRIPTION, LinkedObjectDetails.JSON_PROPERTY_NAME,
        LinkedObjectDetails.JSON_PROPERTY_TITLE, LinkedObjectDetails.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class LinkedObjectDetails implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public static final String JSON_PROPERTY_TYPE = "type";
    private LinkedObjectDetailsType type;

    public LinkedObjectDetails() {
    }

    public LinkedObjectDetails description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the &#x60;primary&#x60; or the &#x60;associated&#x60; relationship
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the `primary` or the `associated` relationship")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public LinkedObjectDetails name(String name) {

        this.name = name;
        return this;
    }

    /**
     * API name of the &#x60;primary&#x60; or the &#x60;associated&#x60; link. The &#x60;name&#x60; parameter can&#39;t
     * start with a number and can only contain the following characters: &#x60;a-z&#x60;, &#x60;A-Z&#x60;,&#x60;
     * 0-9&#x60;, and &#x60;_&#x60;.
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "API name of the `primary` or the `associated` link. The `name` parameter can't start with a number and can only contain the following characters: `a-z`, `A-Z`,` 0-9`, and `_`.")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public LinkedObjectDetails title(String title) {

        this.title = title;
        return this;
    }

    /**
     * Display name of the &#x60;primary&#x60; or the &#x60;associated&#x60; link
     *
     * @return title
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Display name of the `primary` or the `associated` link")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setTitle(String title) {
        this.title = title;
    }

    public LinkedObjectDetails type(LinkedObjectDetailsType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public LinkedObjectDetailsType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(LinkedObjectDetailsType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkedObjectDetails linkedObjectDetails = (LinkedObjectDetails) o;
        return Objects.equals(this.description, linkedObjectDetails.description)
                && Objects.equals(this.name, linkedObjectDetails.name)
                && Objects.equals(this.title, linkedObjectDetails.title)
                && Objects.equals(this.type, linkedObjectDetails.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, name, title, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkedObjectDetails {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
