package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LogIpAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The &#x60;Request&#x60; object describes details that are related to the HTTP request that triggers this event, if
 * available. When the event isn&#39;t sourced to an HTTP request, such as an automatic update on the Okta servers, the
 * &#x60;Request&#x60; object still exists, but the &#x60;ipChain&#x60; field is empty.
 */
@ApiModel(description = "The `Request` object describes details that are related to the HTTP request that triggers this event, if available. When the event isn't sourced to an HTTP request, such as an automatic update on the Okta servers, the `Request` object still exists, but the `ipChain` field is empty.")
@JsonPropertyOrder({ LogRequest.JSON_PROPERTY_IP_CHAIN })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class LogRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_IP_CHAIN = "ipChain";
    private List<LogIpAddress> ipChain = null;

    public LogRequest() {
    }

    /*
     * @JsonCreator public LogRequest(
     *
     * @JsonProperty(JSON_PROPERTY_IP_CHAIN) List<LogIpAddress> ipChain ) { this(); this.ipChain = ipChain; }
     */

    /**
     * If the incoming request passes through any proxies, the IP addresses of those proxies are stored here in the
     * format of clientIp, proxy1, proxy2, and so on. This field is useful when working with trusted proxies.
     *
     * @return ipChain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If the incoming request passes through any proxies, the IP addresses of those proxies are stored here in the format of clientIp, proxy1, proxy2, and so on. This field is useful when working with trusted proxies.")
    @JsonProperty(JSON_PROPERTY_IP_CHAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<LogIpAddress> getIpChain() {
        return ipChain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogRequest logRequest = (LogRequest) o;
        return Objects.equals(this.ipChain, logRequest.ipChain);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ipChain);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogRequest {\n");
        sb.append("    ipChain: ").append(toIndentedString(ipChain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
