package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LogStreamActivateLink;
import com.okta.sdk.resource.model.LogStreamDeactivateLink;
import com.okta.sdk.resource.model.LogStreamSelfLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status
 * of an application using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for
 * dynamic discovery of related resources and lifecycle operations.
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status of an application using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for dynamic discovery of related resources and lifecycle operations.")
@JsonPropertyOrder({ LogStreamLinksSelfAndLifecycle.JSON_PROPERTY_ACTIVATE,
        LogStreamLinksSelfAndLifecycle.JSON_PROPERTY_DEACTIVATE, LogStreamLinksSelfAndLifecycle.JSON_PROPERTY_SELF })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class LogStreamLinksSelfAndLifecycle implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIVATE = "activate";
    private LogStreamActivateLink activate;

    public static final String JSON_PROPERTY_DEACTIVATE = "deactivate";
    private LogStreamDeactivateLink deactivate;

    public static final String JSON_PROPERTY_SELF = "self";
    private LogStreamSelfLink self;

    public LogStreamLinksSelfAndLifecycle() {
    }

    public LogStreamLinksSelfAndLifecycle activate(LogStreamActivateLink activate) {

        this.activate = activate;
        return this;
    }

    /**
     * Get activate
     *
     * @return activate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LogStreamActivateLink getActivate() {
        return activate;
    }

    @JsonProperty(JSON_PROPERTY_ACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setActivate(LogStreamActivateLink activate) {
        this.activate = activate;
    }

    public LogStreamLinksSelfAndLifecycle deactivate(LogStreamDeactivateLink deactivate) {

        this.deactivate = deactivate;
        return this;
    }

    /**
     * Get deactivate
     *
     * @return deactivate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DEACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LogStreamDeactivateLink getDeactivate() {
        return deactivate;
    }

    @JsonProperty(JSON_PROPERTY_DEACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeactivate(LogStreamDeactivateLink deactivate) {
        this.deactivate = deactivate;
    }

    public LogStreamLinksSelfAndLifecycle self(LogStreamSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public LogStreamSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSelf(LogStreamSelfLink self) {
        this.self = self;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogStreamLinksSelfAndLifecycle logStreamLinksSelfAndLifecycle = (LogStreamLinksSelfAndLifecycle) o;
        return Objects.equals(this.activate, logStreamLinksSelfAndLifecycle.activate)
                && Objects.equals(this.deactivate, logStreamLinksSelfAndLifecycle.deactivate)
                && Objects.equals(this.self, logStreamLinksSelfAndLifecycle.self);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(activate, deactivate, self);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStreamLinksSelfAndLifecycle {\n");
        sb.append("    activate: ").append(toIndentedString(activate)).append("\n");
        sb.append("    deactivate: ").append(toIndentedString(deactivate)).append("\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
