package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * \&quot;A user agent is software (a software agent) that is acting on behalf of a user.\&quot; ([Definition of User
 * Agent](https://developer.mozilla.org/en-US/docs/Glossary/User_agent)) In the Okta event data object, the
 * &#x60;UserAgent&#x60; object provides specifications about the client software that makes event-triggering HTTP
 * requests. User agent identification is often useful for identifying interoperability problems between servers and
 * clients, and also for browser and operating system usage analytics.
 */
@ApiModel(description = "\"A user agent is software (a software agent) that is acting on behalf of a user.\" ([Definition of User Agent](https://developer.mozilla.org/en-US/docs/Glossary/User_agent))  In the Okta event data object, the `UserAgent` object provides specifications about the client software that makes event-triggering HTTP requests. User agent identification is often useful for identifying interoperability problems between servers and clients, and also for browser and operating system usage analytics. ")
@JsonPropertyOrder({ LogUserAgent.JSON_PROPERTY_BROWSER, LogUserAgent.JSON_PROPERTY_OS,
        LogUserAgent.JSON_PROPERTY_RAW_USER_AGENT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class LogUserAgent implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BROWSER = "browser";
    private String browser;

    public static final String JSON_PROPERTY_OS = "os";
    private String os;

    public static final String JSON_PROPERTY_RAW_USER_AGENT = "rawUserAgent";
    private String rawUserAgent;

    public LogUserAgent() {
    }

    /*
     * @JsonCreator public LogUserAgent(
     *
     * @JsonProperty(JSON_PROPERTY_BROWSER) String browser,
     *
     * @JsonProperty(JSON_PROPERTY_OS) String os,
     *
     * @JsonProperty(JSON_PROPERTY_RAW_USER_AGENT) String rawUserAgent ) { this(); this.browser = browser; this.os = os;
     * this.rawUserAgent = rawUserAgent; }
     */

    /**
     * If the client is a web browser, this field identifies the type of web browser (for example, CHROME, FIREFOX)
     *
     * @return browser
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If the client is a web browser, this field identifies the type of web browser (for example, CHROME, FIREFOX)")
    @JsonProperty(JSON_PROPERTY_BROWSER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getBrowser() {
        return browser;
    }

    /**
     * The operating system that the client runs on (for example, Windows 10)
     *
     * @return os
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The operating system that the client runs on (for example, Windows 10)")
    @JsonProperty(JSON_PROPERTY_OS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOs() {
        return os;
    }

    /**
     * A raw string representation of the user agent that is formatted according to [section 5.5.3 of HTTP/1.1 Semantics
     * and Content](https://datatracker.ietf.org/doc/html/rfc7231#section-5.5.3). Both the &#x60;browser&#x60; and the
     * &#x60;OS&#x60; fields can be derived from this field.
     *
     * @return rawUserAgent
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A raw string representation of the user agent that is formatted according to [section 5.5.3 of HTTP/1.1 Semantics and Content](https://datatracker.ietf.org/doc/html/rfc7231#section-5.5.3). Both the `browser` and the `OS` fields can be derived from this field.")
    @JsonProperty(JSON_PROPERTY_RAW_USER_AGENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRawUserAgent() {
        return rawUserAgent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogUserAgent logUserAgent = (LogUserAgent) o;
        return Objects.equals(this.browser, logUserAgent.browser) && Objects.equals(this.os, logUserAgent.os)
                && Objects.equals(this.rawUserAgent, logUserAgent.rawUserAgent);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(browser, os, rawUserAgent);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogUserAgent {\n");
        sb.append("    browser: ").append(toIndentedString(browser)).append("\n");
        sb.append("    os: ").append(toIndentedString(os)).append("\n");
        sb.append("    rawUserAgent: ").append(toIndentedString(rawUserAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
