package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth 2.0 and OpenID Connect Client object &gt; **Note:** You must complete client registration with the IdP
 * Authorization Server for your Okta IdP instance to obtain client credentials.
 */
@ApiModel(description = "OAuth 2.0 and OpenID Connect Client object > **Note:** You must complete client registration with the IdP Authorization Server for your Okta IdP instance to obtain client credentials.")
@JsonPropertyOrder({ OAuthCredentialsClient.JSON_PROPERTY_CLIENT_ID, OAuthCredentialsClient.JSON_PROPERTY_CLIENT_SECRET,
        OAuthCredentialsClient.JSON_PROPERTY_PKCE_REQUIRED,
        OAuthCredentialsClient.JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class OAuthCredentialsClient implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;

    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;

    public static final String JSON_PROPERTY_PKCE_REQUIRED = "pkce_required";
    private Boolean pkceRequired;

    /**
     * Client authentication methods supported by the token endpoint
     */
    public enum TokenEndpointAuthMethodEnum {
        PRIVATE_KEY_JWT(String.valueOf("private_key_jwt")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TokenEndpointAuthMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TokenEndpointAuthMethodEnum fromValue(String value) {
            for (TokenEndpointAuthMethodEnum b : TokenEndpointAuthMethodEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD = "token_endpoint_auth_method";
    private TokenEndpointAuthMethodEnum tokenEndpointAuthMethod;

    public OAuthCredentialsClient() {
    }

    public OAuthCredentialsClient clientId(String clientId) {

        this.clientId = clientId;
        return this;
    }

    /**
     * The [Unique identifier](https://tools.ietf.org/html/rfc6749#section-2.2) issued by the AS for the Okta IdP
     * instance
     *
     * @return clientId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "your-client-id", value = "The [Unique identifier](https://tools.ietf.org/html/rfc6749#section-2.2) issued by the AS for the Okta IdP instance")
    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthCredentialsClient clientSecret(String clientSecret) {

        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * The [Client secret](https://tools.ietf.org/html/rfc6749#section-2.3.1) issued by the AS for the Okta IdP instance
     *
     * @return clientSecret
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "your-client-secret", value = "The [Client secret](https://tools.ietf.org/html/rfc6749#section-2.3.1) issued by the AS for the Okta IdP instance")
    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientSecret() {
        return clientSecret;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuthCredentialsClient pkceRequired(Boolean pkceRequired) {

        this.pkceRequired = pkceRequired;
        return this;
    }

    /**
     * Require Proof Key for Code Exchange (PKCE) for additional verification
     *
     * @return pkceRequired
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Require Proof Key for Code Exchange (PKCE) for additional verification")
    @JsonProperty(JSON_PROPERTY_PKCE_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getPkceRequired() {
        return pkceRequired;
    }

    @JsonProperty(JSON_PROPERTY_PKCE_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPkceRequired(Boolean pkceRequired) {
        this.pkceRequired = pkceRequired;
    }

    public OAuthCredentialsClient tokenEndpointAuthMethod(TokenEndpointAuthMethodEnum tokenEndpointAuthMethod) {

        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        return this;
    }

    /**
     * Client authentication methods supported by the token endpoint
     *
     * @return tokenEndpointAuthMethod
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Client authentication methods supported by the token endpoint")
    @JsonProperty(JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenEndpointAuthMethodEnum getTokenEndpointAuthMethod() {
        return tokenEndpointAuthMethod;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTokenEndpointAuthMethod(TokenEndpointAuthMethodEnum tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuthCredentialsClient oauthCredentialsClient = (OAuthCredentialsClient) o;
        return Objects.equals(this.clientId, oauthCredentialsClient.clientId)
                && Objects.equals(this.clientSecret, oauthCredentialsClient.clientSecret)
                && Objects.equals(this.pkceRequired, oauthCredentialsClient.pkceRequired)
                && Objects.equals(this.tokenEndpointAuthMethod, oauthCredentialsClient.tokenEndpointAuthMethod);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, clientSecret, pkceRequired, tokenEndpointAuthMethod);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthCredentialsClient {\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
        sb.append("    pkceRequired: ").append(toIndentedString(pkceRequired)).append("\n");
        sb.append("    tokenEndpointAuthMethod: ").append(toIndentedString(tokenEndpointAuthMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
