package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SchemasJsonWebKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A [JSON Web Key Set](https://tools.ietf.org/html/rfc7517#section-5) for validating JWTs presented to Okta
 */
@ApiModel(description = "A [JSON Web Key Set](https://tools.ietf.org/html/rfc7517#section-5) for validating JWTs presented to Okta")
@JsonPropertyOrder({ OpenIdConnectApplicationSettingsClientKeys.JSON_PROPERTY_KEYS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class OpenIdConnectApplicationSettingsClientKeys implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_KEYS = "keys";
    private List<SchemasJsonWebKey> keys = null;

    public OpenIdConnectApplicationSettingsClientKeys() {
    }

    public OpenIdConnectApplicationSettingsClientKeys keys(List<SchemasJsonWebKey> keys) {

        this.keys = keys;
        return this;
    }

    public OpenIdConnectApplicationSettingsClientKeys addkeysItem(SchemasJsonWebKey keysItem) {
        if (this.keys == null) {
            this.keys = new ArrayList<>();
        }
        this.keys.add(keysItem);
        return this;
    }

    /**
     * Get keys
     *
     * @return keys
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KEYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SchemasJsonWebKey> getKeys() {
        return keys;
    }

    @JsonProperty(JSON_PROPERTY_KEYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKeys(List<SchemasJsonWebKey> keys) {
        this.keys = keys;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OpenIdConnectApplicationSettingsClientKeys openIdConnectApplicationSettingsClientKeys = (OpenIdConnectApplicationSettingsClientKeys) o;
        return Objects.equals(this.keys, openIdConnectApplicationSettingsClientKeys.keys);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(keys);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdConnectApplicationSettingsClientKeys {\n");
        sb.append("    keys: ").append(toIndentedString(keys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
