package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.OperationResponseAssignmentOperation;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OperationResponse
 */
@JsonPropertyOrder({ OperationResponse.JSON_PROPERTY_ASSIGNMENT_OPERATION, OperationResponse.JSON_PROPERTY_COMPLETED,
        OperationResponse.JSON_PROPERTY_CREATED, OperationResponse.JSON_PROPERTY_ID,
        OperationResponse.JSON_PROPERTY_NUM_USER_MOVED, OperationResponse.JSON_PROPERTY_REALM_ID,
        OperationResponse.JSON_PROPERTY_REALM_NAME, OperationResponse.JSON_PROPERTY_STARTED,
        OperationResponse.JSON_PROPERTY_STATUS, OperationResponse.JSON_PROPERTY_TYPE,
        OperationResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class OperationResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ASSIGNMENT_OPERATION = "assignmentOperation";
    private OperationResponseAssignmentOperation assignmentOperation;

    public static final String JSON_PROPERTY_COMPLETED = "completed";
    private OffsetDateTime completed;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NUM_USER_MOVED = "numUserMoved";
    private BigDecimal numUserMoved;

    public static final String JSON_PROPERTY_REALM_ID = "realmId";
    private String realmId;

    public static final String JSON_PROPERTY_REALM_NAME = "realmName";
    private String realmName;

    public static final String JSON_PROPERTY_STARTED = "started";
    private OffsetDateTime started;

    /**
     * Gets or Sets status
     */
    public enum StatusEnum {
        COMPLETED(String.valueOf("COMPLETED")),

        SCHEDULED(String.valueOf("SCHEDULED")),

        IN_PROGRESS(String.valueOf("IN_PROGRESS")),

        FAILED(String.valueOf("FAILED")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public OperationResponse() {
    }

    /*
     * @JsonCreator public OperationResponse(
     *
     * @JsonProperty(JSON_PROPERTY_COMPLETED) OffsetDateTime completed,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_NUM_USER_MOVED) BigDecimal numUserMoved,
     *
     * @JsonProperty(JSON_PROPERTY_REALM_ID) String realmId,
     *
     * @JsonProperty(JSON_PROPERTY_REALM_NAME) String realmName,
     *
     * @JsonProperty(JSON_PROPERTY_STARTED) OffsetDateTime started,
     *
     * @JsonProperty(JSON_PROPERTY_STATUS) StatusEnum status,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.completed = completed; this.created = created;
     * this.id = id; this.numUserMoved = numUserMoved; this.realmId = realmId; this.realmName = realmName; this.started
     * = started; this.status = status; this.type = type; }
     */

    public OperationResponse assignmentOperation(OperationResponseAssignmentOperation assignmentOperation) {

        this.assignmentOperation = assignmentOperation;
        return this;
    }

    /**
     * Get assignmentOperation
     *
     * @return assignmentOperation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASSIGNMENT_OPERATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OperationResponseAssignmentOperation getAssignmentOperation() {
        return assignmentOperation;
    }

    @JsonProperty(JSON_PROPERTY_ASSIGNMENT_OPERATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssignmentOperation(OperationResponseAssignmentOperation assignmentOperation) {
        this.assignmentOperation = assignmentOperation;
    }

    /**
     * Get completed
     *
     * @return completed
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_COMPLETED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCompleted() {
        return completed;
    }

    /**
     * Get created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Get numUserMoved
     *
     * @return numUserMoved
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NUM_USER_MOVED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BigDecimal getNumUserMoved() {
        return numUserMoved;
    }

    /**
     * Get realmId
     *
     * @return realmId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REALM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRealmId() {
        return realmId;
    }

    /**
     * Get realmName
     *
     * @return realmName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REALM_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRealmName() {
        return realmName;
    }

    /**
     * Get started
     *
     * @return started
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STARTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getStarted() {
        return started;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    public OperationResponse links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationResponse operationResponse = (OperationResponse) o;
        return Objects.equals(this.assignmentOperation, operationResponse.assignmentOperation)
                && Objects.equals(this.completed, operationResponse.completed)
                && Objects.equals(this.created, operationResponse.created)
                && Objects.equals(this.id, operationResponse.id)
                && Objects.equals(this.numUserMoved, operationResponse.numUserMoved)
                && Objects.equals(this.realmId, operationResponse.realmId)
                && Objects.equals(this.realmName, operationResponse.realmName)
                && Objects.equals(this.started, operationResponse.started)
                && Objects.equals(this.status, operationResponse.status)
                && Objects.equals(this.type, operationResponse.type)
                && Objects.equals(this.links, operationResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(assignmentOperation, completed, created, id, numUserMoved, realmId, realmName, started,
                status, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationResponse {\n");
        sb.append("    assignmentOperation: ").append(toIndentedString(assignmentOperation)).append("\n");
        sb.append("    completed: ").append(toIndentedString(completed)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    numUserMoved: ").append(toIndentedString(numUserMoved)).append("\n");
        sb.append("    realmId: ").append(toIndentedString(realmId)).append("\n");
        sb.append("    realmName: ").append(toIndentedString(realmName)).append("\n");
        sb.append("    started: ").append(toIndentedString(started)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
