package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EnabledPagesType;
import com.okta.sdk.resource.model.OrgCAPTCHASettingsLinks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
*
*/
@ApiModel(description = "")
@JsonPropertyOrder({ OrgCAPTCHASettings.JSON_PROPERTY_CAPTCHA_ID, OrgCAPTCHASettings.JSON_PROPERTY_ENABLED_PAGES,
        OrgCAPTCHASettings.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class OrgCAPTCHASettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CAPTCHA_ID = "captchaId";
    private String captchaId;

    public static final String JSON_PROPERTY_ENABLED_PAGES = "enabledPages";
    private List<EnabledPagesType> enabledPages = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OrgCAPTCHASettingsLinks links;

    public OrgCAPTCHASettings() {
    }

    public OrgCAPTCHASettings captchaId(String captchaId) {

        this.captchaId = captchaId;
        return this;
    }

    /**
     * The unique key of the associated CAPTCHA instance
     *
     * @return captchaId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique key of the associated CAPTCHA instance")
    @JsonProperty(JSON_PROPERTY_CAPTCHA_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCaptchaId() {
        return captchaId;
    }

    @JsonProperty(JSON_PROPERTY_CAPTCHA_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCaptchaId(String captchaId) {
        this.captchaId = captchaId;
    }

    public OrgCAPTCHASettings enabledPages(List<EnabledPagesType> enabledPages) {

        this.enabledPages = enabledPages;
        return this;
    }

    public OrgCAPTCHASettings addenabledPagesItem(EnabledPagesType enabledPagesItem) {
        if (this.enabledPages == null) {
            this.enabledPages = new ArrayList<>();
        }
        this.enabledPages.add(enabledPagesItem);
        return this;
    }

    /**
     * An array of pages that have CAPTCHA enabled
     *
     * @return enabledPages
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An array of pages that have CAPTCHA enabled")
    @JsonProperty(JSON_PROPERTY_ENABLED_PAGES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<EnabledPagesType> getEnabledPages() {
        return enabledPages;
    }

    @JsonProperty(JSON_PROPERTY_ENABLED_PAGES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnabledPages(List<EnabledPagesType> enabledPages) {
        this.enabledPages = enabledPages;
    }

    public OrgCAPTCHASettings links(OrgCAPTCHASettingsLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgCAPTCHASettingsLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OrgCAPTCHASettingsLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgCAPTCHASettings orgCAPTCHASettings = (OrgCAPTCHASettings) o;
        return Objects.equals(this.captchaId, orgCAPTCHASettings.captchaId)
                && Objects.equals(this.enabledPages, orgCAPTCHASettings.enabledPages)
                && Objects.equals(this.links, orgCAPTCHASettings.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(captchaId, enabledPages, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgCAPTCHASettings {\n");
        sb.append("    captchaId: ").append(toIndentedString(captchaId)).append("\n");
        sb.append("    enabledPages: ").append(toIndentedString(enabledPages)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
