package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies a password for a user &gt; **Note:** For information on defaults and configuring your password policies,
 * see [Configure the password
 * authenticator](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-configure-password) in the help
 * documentation.
 */
@ApiModel(description = "Specifies a password for a user > **Note:** For information on defaults and configuring your password policies, see [Configure the password authenticator](https://help.okta.com/okta_help.htm?type=oie&id=ext-configure-password) in the help documentation.")
@JsonPropertyOrder({ OrgCreationAdminCredentialsPassword.JSON_PROPERTY_VALUE })
@JsonTypeName("OrgCreationAdmin_credentials_password")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class OrgCreationAdminCredentialsPassword implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public OrgCreationAdminCredentialsPassword() {
    }

    public OrgCreationAdminCredentialsPassword value(String value) {

        this.value = value;
        return this;
    }

    /**
     * Password value (which is validated by the Password Policy)
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "pa$$word", value = "Password value (which is validated by the Password Policy)")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgCreationAdminCredentialsPassword orgCreationAdminCredentialsPassword = (OrgCreationAdminCredentialsPassword) o;
        return Objects.equals(this.value, orgCreationAdminCredentialsPassword.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgCreationAdminCredentialsPassword {\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
