package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.PasswordPolicyConditions;
import com.okta.sdk.resource.model.PasswordPolicySettings;
import com.okta.sdk.resource.model.Policy;
import com.okta.sdk.resource.model.PolicyLinks;
import com.okta.sdk.resource.model.PolicyType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PasswordPolicy
 */
@JsonPropertyOrder({ PasswordPolicy.JSON_PROPERTY_CONDITIONS, PasswordPolicy.JSON_PROPERTY_SETTINGS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = PasswordPolicy.class)

public class PasswordPolicy extends Policy implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private PasswordPolicyConditions conditions;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private PasswordPolicySettings settings;

    public PasswordPolicy() {
    }

    /*
     * @JsonCreator public PasswordPolicy(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.created = created; this.id =
     * id; this.lastUpdated = lastUpdated; this.embedded = embedded; }
     */

    public PasswordPolicy conditions(PasswordPolicyConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordPolicyConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(PasswordPolicyConditions conditions) {
        this.conditions = conditions;
    }

    public PasswordPolicy settings(PasswordPolicySettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordPolicySettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(PasswordPolicySettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicy passwordPolicy = (PasswordPolicy) o;
        return Objects.equals(this.conditions, passwordPolicy.conditions)
                && Objects.equals(this.settings, passwordPolicy.settings);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(conditions, settings, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicy {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
