package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Age settings
 */
@ApiModel(description = "Age settings")
@JsonPropertyOrder({ PasswordPolicyPasswordSettingsAge.JSON_PROPERTY_EXPIRE_WARN_DAYS,
        PasswordPolicyPasswordSettingsAge.JSON_PROPERTY_HISTORY_COUNT,
        PasswordPolicyPasswordSettingsAge.JSON_PROPERTY_MAX_AGE_DAYS,
        PasswordPolicyPasswordSettingsAge.JSON_PROPERTY_MIN_AGE_MINUTES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class PasswordPolicyPasswordSettingsAge implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPIRE_WARN_DAYS = "expireWarnDays";
    private Integer expireWarnDays = 0;

    public static final String JSON_PROPERTY_HISTORY_COUNT = "historyCount";
    private Integer historyCount = 0;

    public static final String JSON_PROPERTY_MAX_AGE_DAYS = "maxAgeDays";
    private Integer maxAgeDays = 0;

    public static final String JSON_PROPERTY_MIN_AGE_MINUTES = "minAgeMinutes";
    private Integer minAgeMinutes = 0;

    public PasswordPolicyPasswordSettingsAge() {
    }

    public PasswordPolicyPasswordSettingsAge expireWarnDays(Integer expireWarnDays) {

        this.expireWarnDays = expireWarnDays;
        return this;
    }

    /**
     * Specifies the number of days prior to password expiration when a User is warned to reset their password:
     * &#x60;0&#x60; indicates no warning
     *
     * @return expireWarnDays
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the number of days prior to password expiration when a User is warned to reset their password: `0` indicates no warning")
    @JsonProperty(JSON_PROPERTY_EXPIRE_WARN_DAYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getExpireWarnDays() {
        return expireWarnDays;
    }

    @JsonProperty(JSON_PROPERTY_EXPIRE_WARN_DAYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExpireWarnDays(Integer expireWarnDays) {
        this.expireWarnDays = expireWarnDays;
    }

    public PasswordPolicyPasswordSettingsAge historyCount(Integer historyCount) {

        this.historyCount = historyCount;
        return this;
    }

    /**
     * Specifies the number of distinct passwords that a User must create before they can reuse a previous password:
     * &#x60;0&#x60; indicates none
     *
     * @return historyCount
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the number of distinct passwords that a User must create before they can reuse a previous password: `0` indicates none")
    @JsonProperty(JSON_PROPERTY_HISTORY_COUNT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getHistoryCount() {
        return historyCount;
    }

    @JsonProperty(JSON_PROPERTY_HISTORY_COUNT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHistoryCount(Integer historyCount) {
        this.historyCount = historyCount;
    }

    public PasswordPolicyPasswordSettingsAge maxAgeDays(Integer maxAgeDays) {

        this.maxAgeDays = maxAgeDays;
        return this;
    }

    /**
     * Specifies how long (in days) a password remains valid before it expires: &#x60;0&#x60; indicates no limit
     *
     * @return maxAgeDays
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies how long (in days) a password remains valid before it expires: `0` indicates no limit")
    @JsonProperty(JSON_PROPERTY_MAX_AGE_DAYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMaxAgeDays() {
        return maxAgeDays;
    }

    @JsonProperty(JSON_PROPERTY_MAX_AGE_DAYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMaxAgeDays(Integer maxAgeDays) {
        this.maxAgeDays = maxAgeDays;
    }

    public PasswordPolicyPasswordSettingsAge minAgeMinutes(Integer minAgeMinutes) {

        this.minAgeMinutes = minAgeMinutes;
        return this;
    }

    /**
     * Specifies the minimum time interval (in minutes) between password changes: &#x60;0&#x60; indicates no limit
     *
     * @return minAgeMinutes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the minimum time interval (in minutes) between password changes: `0` indicates no limit")
    @JsonProperty(JSON_PROPERTY_MIN_AGE_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMinAgeMinutes() {
        return minAgeMinutes;
    }

    @JsonProperty(JSON_PROPERTY_MIN_AGE_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeMinutes(Integer minAgeMinutes) {
        this.minAgeMinutes = minAgeMinutes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyPasswordSettingsAge passwordPolicyPasswordSettingsAge = (PasswordPolicyPasswordSettingsAge) o;
        return Objects.equals(this.expireWarnDays, passwordPolicyPasswordSettingsAge.expireWarnDays)
                && Objects.equals(this.historyCount, passwordPolicyPasswordSettingsAge.historyCount)
                && Objects.equals(this.maxAgeDays, passwordPolicyPasswordSettingsAge.maxAgeDays)
                && Objects.equals(this.minAgeMinutes, passwordPolicyPasswordSettingsAge.minAgeMinutes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expireWarnDays, historyCount, maxAgeDays, minAgeMinutes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicyPasswordSettingsAge {\n");
        sb.append("    expireWarnDays: ").append(toIndentedString(expireWarnDays)).append("\n");
        sb.append("    historyCount: ").append(toIndentedString(historyCount)).append("\n");
        sb.append("    maxAgeDays: ").append(toIndentedString(maxAgeDays)).append("\n");
        sb.append("    minAgeMinutes: ").append(toIndentedString(minAgeMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
