package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PolicyNetworkConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PolicyNetworkCondition
 */
@JsonPropertyOrder({ PolicyNetworkCondition.JSON_PROPERTY_CONNECTION, PolicyNetworkCondition.JSON_PROPERTY_EXCLUDE,
        PolicyNetworkCondition.JSON_PROPERTY_INCLUDE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class PolicyNetworkCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private PolicyNetworkConnection connection;

    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<String> exclude = null;

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = null;

    public PolicyNetworkCondition() {
    }

    public PolicyNetworkCondition connection(PolicyNetworkConnection connection) {

        this.connection = connection;
        return this;
    }

    /**
     * Get connection
     *
     * @return connection
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONNECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyNetworkConnection getConnection() {
        return connection;
    }

    @JsonProperty(JSON_PROPERTY_CONNECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(PolicyNetworkConnection connection) {
        this.connection = connection;
    }

    public PolicyNetworkCondition exclude(List<String> exclude) {

        this.exclude = exclude;
        return this;
    }

    public PolicyNetworkCondition addexcludeItem(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    /**
     * The zones to exclude. Required only if connection data type is &#x60;ZONE&#x60;
     *
     * @return exclude
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The zones to exclude. Required only if connection data type is `ZONE`")
    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getExclude() {
        return exclude;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public PolicyNetworkCondition include(List<String> include) {

        this.include = include;
        return this;
    }

    public PolicyNetworkCondition addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<>();
        }
        this.include.add(includeItem);
        return this;
    }

    /**
     * The zones to include. Required only if connection data type is &#x60;ZONE&#x60;
     *
     * @return include
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The zones to include. Required only if connection data type is `ZONE`")
    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getInclude() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PolicyNetworkCondition policyNetworkCondition = (PolicyNetworkCondition) o;
        return Objects.equals(this.connection, policyNetworkCondition.connection)
                && Objects.equals(this.exclude, policyNetworkCondition.exclude)
                && Objects.equals(this.include, policyNetworkCondition.include);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(connection, exclude, include);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyNetworkCondition {\n");
        sb.append("    connection: ").append(toIndentedString(connection)).append("\n");
        sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
