package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupCondition;
import com.okta.sdk.resource.model.UserCondition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Identifies Users and Groups that are used together
 */
@ApiModel(description = "Identifies Users and Groups that are used together")
@JsonPropertyOrder({ PolicyPeopleCondition.JSON_PROPERTY_GROUPS, PolicyPeopleCondition.JSON_PROPERTY_USERS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class PolicyPeopleCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private GroupCondition groups;

    public static final String JSON_PROPERTY_USERS = "users";
    private UserCondition users;

    public PolicyPeopleCondition() {
    }

    public PolicyPeopleCondition groups(GroupCondition groups) {

        this.groups = groups;
        return this;
    }

    /**
     * Get groups
     *
     * @return groups
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public GroupCondition getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setGroups(GroupCondition groups) {
        this.groups = groups;
    }

    public PolicyPeopleCondition users(UserCondition users) {

        this.users = users;
        return this;
    }

    /**
     * Get users
     *
     * @return users
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public UserCondition getUsers() {
        return users;
    }

    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUsers(UserCondition users) {
        this.users = users;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PolicyPeopleCondition policyPeopleCondition = (PolicyPeopleCondition) o;
        return Objects.equals(this.groups, policyPeopleCondition.groups)
                && Objects.equals(this.users, policyPeopleCondition.users);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groups, users);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyPeopleCondition {\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    users: ").append(toIndentedString(users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
