package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CredentialSyncInfo;
import com.okta.sdk.resource.model.PrivilegedResourceStatus;
import com.okta.sdk.resource.model.PrivilegedResourceType;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PrivilegedResource
 */
@JsonPropertyOrder({ PrivilegedResource.JSON_PROPERTY_CREATED, PrivilegedResource.JSON_PROPERTY_CREDENTIAL_SYNC_INFO,
        PrivilegedResource.JSON_PROPERTY_ID, PrivilegedResource.JSON_PROPERTY_LAST_UPDATED,
        PrivilegedResource.JSON_PROPERTY_RESOURCE_TYPE, PrivilegedResource.JSON_PROPERTY_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "resourceType", visible = true, defaultImpl = PrivilegedResource.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = PrivilegedResourceAccountApp.class, name = "APP_ACCOUNT"),
        @JsonSubTypes.Type(value = PrivilegedResourceAccountOkta.class, name = "OKTA_USER_ACCOUNT"), })

public class PrivilegedResource implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_CREDENTIAL_SYNC_INFO = "credentialSyncInfo";
    private CredentialSyncInfo credentialSyncInfo;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    protected PrivilegedResourceType resourceType;

    public static final String JSON_PROPERTY_STATUS = "status";
    private PrivilegedResourceStatus status;

    public PrivilegedResource() {
    }

    /*
     * @JsonCreator public PrivilegedResource(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    /**
     * Timestamp when the object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2024-06-10T11:11:01Z", value = "Timestamp when the object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public PrivilegedResource credentialSyncInfo(CredentialSyncInfo credentialSyncInfo) {

        this.credentialSyncInfo = credentialSyncInfo;
        return this;
    }

    /**
     * Get credentialSyncInfo
     *
     * @return credentialSyncInfo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIAL_SYNC_INFO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CredentialSyncInfo getCredentialSyncInfo() {
        return credentialSyncInfo;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIAL_SYNC_INFO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentialSyncInfo(CredentialSyncInfo credentialSyncInfo) {
        this.credentialSyncInfo = credentialSyncInfo;
    }

    /**
     * ID of the privileged resource
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "opa100xTfFs4MasRf0g4", value = "ID of the privileged resource")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2024-06-10T11:13:01Z", value = "Timestamp when the object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public PrivilegedResource resourceType(PrivilegedResourceType resourceType) {

        this.resourceType = resourceType;
        return this;
    }

    /**
     * Get resourceType
     *
     * @return resourceType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PrivilegedResourceType getResourceType() {
        return resourceType;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(PrivilegedResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public PrivilegedResource status(PrivilegedResourceStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PrivilegedResourceStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(PrivilegedResourceStatus status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedResource privilegedResource = (PrivilegedResource) o;
        return Objects.equals(this.created, privilegedResource.created)
                && Objects.equals(this.credentialSyncInfo, privilegedResource.credentialSyncInfo)
                && Objects.equals(this.id, privilegedResource.id)
                && Objects.equals(this.lastUpdated, privilegedResource.lastUpdated)
                && Objects.equals(this.resourceType, privilegedResource.resourceType)
                && Objects.equals(this.status, privilegedResource.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, credentialSyncInfo, id, lastUpdated, resourceType, status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedResource {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    credentialSyncInfo: ").append(toIndentedString(credentialSyncInfo)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
