package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.ProfileMappingProperty;
import com.okta.sdk.resource.model.ProfileMappingSource;
import com.okta.sdk.resource.model.ProfileMappingTarget;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The Profile Mapping object describes a mapping between an Okta User&#39;s and an App User&#39;s properties using
 * [JSON Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04). &gt; **Note:** Same type
 * source/target mappings aren&#39;t supported by this API. Profile mappings must either be Okta-&gt;App or
 * App-&gt;Okta.
 */
@ApiModel(description = "The Profile Mapping object describes a mapping between an Okta User's and an App User's properties using [JSON Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04).  > **Note:** Same type source/target mappings aren't supported by this API. Profile mappings must either be Okta->App or App->Okta.")
@JsonPropertyOrder({ ProfileMapping.JSON_PROPERTY_ID, ProfileMapping.JSON_PROPERTY_PROPERTIES,
        ProfileMapping.JSON_PROPERTY_SOURCE, ProfileMapping.JSON_PROPERTY_TARGET, ProfileMapping.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ProfileMapping implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, ProfileMappingProperty> properties = null;

    public static final String JSON_PROPERTY_SOURCE = "source";
    private ProfileMappingSource source;

    public static final String JSON_PROPERTY_TARGET = "target";
    private ProfileMappingTarget target;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public ProfileMapping() {
    }

    /*
     * @JsonCreator public ProfileMapping(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id ) { this(); this.id = id; }
     */

    /**
     * Unique identifier for a profile mapping
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for a profile mapping")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public ProfileMapping properties(Map<String, ProfileMappingProperty> properties) {

        this.properties = properties;
        return this;
    }

    public ProfileMapping putpropertiesItem(String key, ProfileMappingProperty propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    /**
     * Get properties
     *
     * @return properties
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, ProfileMappingProperty> getProperties() {
        return properties;
    }

    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, ProfileMappingProperty> properties) {
        this.properties = properties;
    }

    public ProfileMapping source(ProfileMappingSource source) {

        this.source = source;
        return this;
    }

    /**
     * Get source
     *
     * @return source
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProfileMappingSource getSource() {
        return source;
    }

    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSource(ProfileMappingSource source) {
        this.source = source;
    }

    public ProfileMapping target(ProfileMappingTarget target) {

        this.target = target;
        return this;
    }

    /**
     * Get target
     *
     * @return target
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TARGET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProfileMappingTarget getTarget() {
        return target;
    }

    @JsonProperty(JSON_PROPERTY_TARGET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTarget(ProfileMappingTarget target) {
        this.target = target;
    }

    public ProfileMapping links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProfileMapping profileMapping = (ProfileMapping) o;
        return Objects.equals(this.id, profileMapping.id) && Objects.equals(this.properties, profileMapping.properties)
                && Objects.equals(this.source, profileMapping.source)
                && Objects.equals(this.target, profileMapping.target)
                && Objects.equals(this.links, profileMapping.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, properties, source, target, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProfileMapping {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    source: ").append(toIndentedString(source)).append("\n");
        sb.append("    target: ").append(toIndentedString(target)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
