package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthCredentials;
import com.okta.sdk.resource.model.OAuthEndpoints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Protocol settings for authentication using the [OAuth 2.0 Authorization Code
 * flow](https://tools.ietf.org/html/rfc6749#section-4.1)
 */
@ApiModel(description = "Protocol settings for authentication using the [OAuth 2.0 Authorization Code flow](https://tools.ietf.org/html/rfc6749#section-4.1)")
@JsonPropertyOrder({ ProtocolOAuth.JSON_PROPERTY_CREDENTIALS, ProtocolOAuth.JSON_PROPERTY_ENDPOINTS,
        ProtocolOAuth.JSON_PROPERTY_SCOPES, ProtocolOAuth.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ProtocolOAuth implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private OAuthCredentials credentials;

    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private OAuthEndpoints endpoints;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;

    /**
     * OAuth 2.0 Authorization Code flow
     */
    public enum TypeEnum {
        OAUTH2(String.valueOf("OAUTH2")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ProtocolOAuth() {
    }

    public ProtocolOAuth credentials(OAuthCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(OAuthCredentials credentials) {
        this.credentials = credentials;
    }

    public ProtocolOAuth endpoints(OAuthEndpoints endpoints) {

        this.endpoints = endpoints;
        return this;
    }

    /**
     * Get endpoints
     *
     * @return endpoints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ENDPOINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthEndpoints getEndpoints() {
        return endpoints;
    }

    @JsonProperty(JSON_PROPERTY_ENDPOINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(OAuthEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public ProtocolOAuth scopes(List<String> scopes) {

        this.scopes = scopes;
        return this;
    }

    public ProtocolOAuth addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    /**
     * IdP-defined permission bundles to request delegated access from the User &gt; **Note:** The [Identity Provider
     * type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path&#x3D;type&amp;t&#x3D;request)
     * table lists the scopes that are supported for each Identity Provider.
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "IdP-defined permission bundles to request delegated access from the User > **Note:** The [Identity Provider type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=type&t=request) table lists the scopes that are supported for each Identity Provider.")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getScopes() {
        return scopes;
    }

    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ProtocolOAuth type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * OAuth 2.0 Authorization Code flow
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "OAuth 2.0 Authorization Code flow")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProtocolOAuth protocolOAuth = (ProtocolOAuth) o;
        return Objects.equals(this.credentials, protocolOAuth.credentials)
                && Objects.equals(this.endpoints, protocolOAuth.endpoints)
                && Objects.equals(this.scopes, protocolOAuth.scopes) && Objects.equals(this.type, protocolOAuth.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credentials, endpoints, scopes, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolOAuth {\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    endpoints: ").append(toIndentedString(endpoints)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
